/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.trust;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorsePlayerTrustLevel;
import com.equestricraft.common.TrustAction;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.trust.HorsePlayerTrust;
import com.equestricraft.core.horse.trust.HorsePlayerTrustInfo;
import com.equestricraft.core.horse.trust.HorsePlayerTrustRepository;
import com.equestricraft.core.horse.trust.HorsePlayerTrustSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.trust.action.TrustActionConfig;
import com.equestricraft.core.trust.action.TrustActionConfigRepository;
import com.equestricraft.core.trust.level.TrustLevelConfig;
import com.equestricraft.core.trust.level.TrustLevelConfigRepository;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class HorsePlayerTrustSessionImpl
implements HorsePlayerTrustSession {
    @Service
    private HorsePlayerTrustRepository horsePlayerTrustRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private TrustActionConfigRepository trustActionConfigRepository;
    @Service
    private TrustLevelConfigRepository trustLevelConfigRepository;
    private static final int MINIMUM_POINTS = 0;
    private static final int MAXIMUM_POINTS = 100;

    @Override
    public HorsePlayerTrust initialisePlayerTrustWithHorse(ECPlayer player, EQHorse horse) {
        Optional<HorsePlayerTrust> existing = this.horsePlayerTrustRepository.findByHorseAndPlayer(horse.getId(), player.getId());
        if (existing.isPresent()) {
            throw new IllegalArgumentException("Horse and player already have trust");
        }
        int points = horse.getOwnerId() == player.getId() ? HorseSettings.getTrustInitialOwner() : HorseSettings.getTrustNonOwner();
        HorsePlayerTrust newTrust = new HorsePlayerTrust(horse.getId(), player.getId(), points);
        return this.horsePlayerTrustRepository.add(newTrust);
    }

    @Override
    public HorsePlayerTrust initialisePlayerTrustWithHorse(ECPlayer player, EQHorse horse, int points) {
        Optional<HorsePlayerTrust> existing = this.horsePlayerTrustRepository.findByHorseAndPlayer(horse.getId(), player.getId());
        if (existing.isPresent()) {
            throw new IllegalArgumentException("Horse and player already have trust");
        }
        points = NumberUtils.keepWithinRange(points, 0, 100);
        HorsePlayerTrust newTrust = new HorsePlayerTrust(horse.getId(), player.getId(), points);
        return this.horsePlayerTrustRepository.add(newTrust);
    }

    private HorsePlayerTrust initialisePlayerTrustWithHorse(ECPlayer player, int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        return this.initialisePlayerTrustWithHorse(player, horse);
    }

    @Override
    public void processTrustAction(ECPlayer player, int horseId, TrustAction trustAction) {
        this.processTrustAction(player, horseId, trustAction, null);
    }

    @Override
    public void processTrustAction(ECPlayer player, int horseId, TrustAction trustAction, Integer additionalDataValue) {
        int points = this.determinePoints(trustAction, additionalDataValue);
        this.offsetTrustPointsForPlayerAndHorse(player, horseId, points);
    }

    private int determinePoints(TrustAction trustAction, Integer additionalDataValue) {
        TrustActionConfig config = (TrustActionConfig)this.trustActionConfigRepository.findByKey(trustAction);
        if (config.getAdditionalConfigValue() != null) {
            if (additionalDataValue == null) {
                throw new IllegalArgumentException(String.format("No additional data value has been provided for trust action %s", trustAction.name()));
            }
            return additionalDataValue * config.getAdditionalConfigValue() * config.getPoints();
        }
        return config.getPoints();
    }

    @Override
    public void increaseTrustPoints(ECPlayer player, int horseId, int points) {
        if (points < 0) {
            throw new IllegalArgumentException("Value cannot be less than zero");
        }
        if (points == 0) {
            return;
        }
        this.offsetTrustPointsForPlayerAndHorse(player, horseId, points);
    }

    @Override
    public void decreaseTrustPoints(ECPlayer player, int horseId, int points) {
        if (points < 0) {
            throw new IllegalArgumentException("Value cannot be less than zero");
        }
        if (points == 0) {
            return;
        }
        this.offsetTrustPointsForPlayerAndHorse(player, horseId, -points);
    }

    private void offsetTrustPointsForPlayerAndHorse(ECPlayer player, int horseId, int offset) {
        HorsePlayerTrust horsePlayerTrust = this.horsePlayerTrustRepository.findByHorseAndPlayer(horseId, player.getId()).orElseGet(() -> this.initialisePlayerTrustWithHorse(player, horseId));
        this.offsetPoints(offset, horsePlayerTrust);
    }

    private void offsetPoints(int offset, HorsePlayerTrust horsePlayerTrust) {
        int newPoints = horsePlayerTrust.getTrustPoints() + offset;
        newPoints = NumberUtils.keepWithinRange(newPoints, 0, 100);
        horsePlayerTrust.setTrustPoints(newPoints);
        horsePlayerTrust.save();
    }

    @Override
    public int getTrustPointsForPlayerAndHorse(ECPlayer player, int horseId) {
        Optional<HorsePlayerTrust> horsePlayerTrust = this.horsePlayerTrustRepository.findByHorseAndPlayer(horseId, player.getId());
        return horsePlayerTrust.map(HorsePlayerTrust::getTrustPoints).orElse(HorseSettings.getTrustNonOwner());
    }

    @Override
    public HorsePlayerTrustLevel getTrustLevelForPlayerAndHorse(ECPlayer player, int horseId) {
        int points = this.getTrustPointsForPlayerAndHorse(player, horseId);
        return this.getLevelForPoints(points);
    }

    @Override
    public HorsePlayerTrustInfo getTrustLevelInfoForPlayerAndHorse(ECPlayer player, int horseId) {
        int points = this.getTrustPointsForPlayerAndHorse(player, horseId);
        HorsePlayerTrustLevel level = this.getLevelForPoints(points);
        TrustLevelConfig config = (TrustLevelConfig)this.trustLevelConfigRepository.findByKey(level);
        return new HorsePlayerTrustInfo(player.getId(), level, config);
    }

    private HorsePlayerTrustLevel getLevelForPoints(int points) {
        return Arrays.stream(HorsePlayerTrustLevel.values()).sorted(Comparator.comparingInt(HorsePlayerTrustLevel::getMinimumPoints).reversed()).filter(l -> l.getMinimumPoints() <= points).findFirst().orElse(HorsePlayerTrustLevel.NO_TRUST);
    }
}

