/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.trust;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorsePlayerTrustLevel;
import com.equestricraft.common.TrustAction;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.trust.HorsePlayerTrustInfo;
import com.equestricraft.core.horse.trust.HorsePlayerTrustSession;
import com.equestricraft.core.player.ECPlayer;

public class HorseTrustAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorsePlayerTrustSession horsePlayerTrustSession;

    public HorseTrustAccessor(EQHorse horse) {
        super(horse);
    }

    public void processAction(ECPlayer player, TrustAction action) {
        horsePlayerTrustSession.processTrustAction(player, this.horse.getId(), action);
    }

    public void processAction(ECPlayer player, TrustAction action, Integer additionalDataValue) {
        horsePlayerTrustSession.processTrustAction(player, this.horse.getId(), action, additionalDataValue);
    }

    public int getValue(ECPlayer player) {
        return horsePlayerTrustSession.getTrustPointsForPlayerAndHorse(player, this.horse.getId());
    }

    public HorsePlayerTrustLevel getLevel(ECPlayer player) {
        return horsePlayerTrustSession.getTrustLevelForPlayerAndHorse(player, this.horse.getId());
    }

    public HorsePlayerTrustInfo getLevelInfo(ECPlayer player) {
        return horsePlayerTrustSession.getTrustLevelInfoForPlayerAndHorse(player, this.horse.getId());
    }

    public void increase(ECPlayer player, int value) {
        horsePlayerTrustSession.increaseTrustPoints(player, this.horse.getId(), value);
    }

    public void decrease(ECPlayer player, int value) {
        horsePlayerTrustSession.decreaseTrustPoints(player, this.horse.getId(), value);
    }
}

