/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.warmup;

import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.featureflag.FeatureFlag;

public class HorseWarmUpAccessor
extends AbstractHorseAccessor {
    private long value = 0L;

    public HorseWarmUpAccessor(EQHorse horse) {
        super(horse);
    }

    @Override
    public void activeTick() {
        this.stepTowardsValue(this.horse.getGait().getCurrentGait().getTargetWarmUpScore());
    }

    private void stepTowardsValue(long target) {
        if (target > this.value) {
            ++this.value;
        } else if (target < this.value) {
            --this.value;
        }
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void increaseWarmUpValue(long amount) {
        if (amount < 0L) {
            throw new IllegalStateException("Value cannot be less than zero");
        }
        this.value += amount;
    }

    public void decreaseWarmUpValue(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Value cannot be less than zero");
        }
        this.value -= amount;
    }

    public boolean isWarmedUpForGait(HorseSubGait targetGait) {
        if (FeatureFlag.WARMING_UP.isDisabled()) {
            return true;
        }
        return this.value >= targetGait.getRequiredWarmUpScore();
    }
}

