/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.weight;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.weight.HorseWeightInfo;
import com.equestricraft.core.horse.weight.HorseWeightSession;
import com.equestricraft.core.horse.weight.WeightStatus;
import java.time.Duration;
import java.util.Optional;

public class HorseWeightAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseWeightSession horseWeightSession;
    private final CachedValue<Double> weightValue = new CachedValue<Double>(this::getUpdatedWeightValue, Duration.ofMinutes(2L));

    public HorseWeightAccessor(EQHorse horse) {
        super(horse);
    }

    public double getValue() {
        return this.weightValue.get();
    }

    public double getTargetValue() {
        return horseWeightSession.getTargetWeight(this.horse);
    }

    public double getPercentageOfTargetWeight() {
        double targetWeight = this.getTargetValue();
        double weight = this.getValue();
        return weight / targetWeight * 100.0;
    }

    public void logCurrent() {
        horseWeightSession.setHorsesLastRecordedWeight(this.horse);
    }

    public Optional<HorseWeightInfo> getInformation() {
        return horseWeightSession.getHorsesWeightInfo(this.horse);
    }

    public WeightStatus getStatus() {
        return horseWeightSession.determineHorsesWeightStatus(this.horse);
    }

    private double getUpdatedWeightValue() {
        return horseWeightSession.getHorsesWeight(this.horse);
    }
}

