/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.weight;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.weight.HorseWeightLog;
import java.util.List;

public class HorseWeightLogDatabase
implements RepositoryDatasource<HorseWeightLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_WEIGHT = "WEIGHT";

    @Override
    public void create(HorseWeightLog horseWeightLog) {
        Query.insertInto("HORSE_WEIGHT_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseWeightLog.getHorseId()), QueryColumn.column(COLUMN_TIME_STAMP, horseWeightLog.getTimeStamp()), QueryColumn.column(COLUMN_WEIGHT, horseWeightLog.getWeight())).executeGetGeneratedKey(horseWeightLog::setId);
    }

    @Override
    public List<HorseWeightLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_WEIGHT_LOG").getList(this::getFromResultRow);
    }

    private HorseWeightLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        double weight = row.getDouble(COLUMN_WEIGHT);
        return new HorseWeightLog(id, horseId, timeStamp, weight);
    }
}

