/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.weight;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.weight.HorseWeightLog;
import com.equestricraft.core.horse.weight.HorseWeightLogEntry;
import com.equestricraft.core.horse.weight.HorseWeightLogPaginationSession;
import com.equestricraft.core.horse.weight.HorseWeightLogRepository;
import com.equestricraft.core.horse.weight.HorseWeightPage;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class HorseWeightLogPaginationSessionImpl
extends Pagination<HorseWeightLogEntry, HorseWeightPage, Object, Object>
implements HorseWeightLogPaginationSession {
    @Service
    private HorseWeightLogRepository horseWeightLogRepository;

    @Override
    public HorseWeightPage retrieveHorseWeightLogPage(int horseId, int pageNumber, SortDirection sortDirection) {
        List<HorseWeightLog> logs = this.horseWeightLogRepository.findByHorse(horseId);
        List<HorseWeightLogEntry> entries = logs.stream().map(this::buildEntry).toList();
        return (HorseWeightPage)this.paginate(entries, pageNumber, sortDirection, null, null);
    }

    private HorseWeightLogEntry buildEntry(HorseWeightLog horseWeightLog) {
        return new HorseWeightLogEntry(horseWeightLog.getWeight(), new Date(horseWeightLog.getTimeStamp()));
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(HorseWeightLogEntry item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<HorseWeightLogEntry> compare(Object sortOrderObject) {
        return Comparator.comparing(HorseWeightLogEntry::timeStamp).reversed();
    }

    @Override
    protected HorseWeightPage buildPage(List<HorseWeightLogEntry> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new HorseWeightPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

