/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.weight;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.weight.HorseWeightLog;
import com.equestricraft.core.horse.weight.HorseWeightLogDatabase;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HorseWeightLogRepository
extends Repository<HorseWeightLog, Integer> {
    @Service
    private HorseWeightLogDatabase horseWeightLogDatabase;

    @Override
    protected RepositoryDatasource<HorseWeightLog, Integer> getDatasource() {
        return this.horseWeightLogDatabase;
    }

    @Override
    protected Function<HorseWeightLog, Object> getIndexFunction() {
        return HorseWeightLog::getHorseId;
    }

    public List<HorseWeightLog> findByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public Optional<HorseWeightLog> findMostRecentByHorse(int horseId) {
        RepositorySearchQuery<HorseWeightLog> searchQuery = this.createSearchQuery();
        searchQuery.filter(l -> l.getHorseId() == horseId);
        searchQuery.sortReverse(Comparator.comparingLong(HorseWeightLog::getTimeStamp));
        return searchQuery.single();
    }
}

