/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.weight;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.weight.HorseWeightInfo;
import com.equestricraft.core.horse.weight.HorseWeightLog;
import com.equestricraft.core.horse.weight.HorseWeightLogSession;
import com.equestricraft.core.horse.weight.HorseWeightSession;
import com.equestricraft.core.horse.weight.HorseWeightSettings;
import com.equestricraft.core.horse.weight.WeightStatus;
import java.util.Date;
import java.util.Optional;

public class HorseWeightSessionImpl
implements HorseWeightSession {
    @Service
    private HorseWeightLogSession horseWeightLogSession;
    @Service
    private AgeSettingSession ageSettingSession;

    @Override
    public double getHorsesWeight(EQHorse horse) {
        double weight = this.getTargetWeight(horse);
        double calories = horse.getNutrition().getCalories();
        double kilograms = calories / HorseWeightSettings.getCaloriesPerKilogram();
        return weight + kilograms;
    }

    @Override
    public void setHorsesLastRecordedWeight(EQHorse horse) {
        double weight = this.getHorsesWeight(horse);
        this.horseWeightLogSession.logHorseWeight(horse, weight);
        horse.save();
    }

    @Override
    public Optional<HorseWeightInfo> getHorsesWeightInfo(EQHorse horse) {
        Optional<HorseWeightLog> mostRecentLog = this.horseWeightLogSession.findMostRecentWeightLogForHorse(horse);
        if (mostRecentLog.isPresent()) {
            double weight = mostRecentLog.get().getWeight();
            double targetWeight = this.getTargetWeight(horse);
            WeightStatus weightStatus = this.determineHorsesWeightStatus(targetWeight, weight);
            Date lastTime = new Date(mostRecentLog.get().getTimeStamp());
            return Optional.of(new HorseWeightInfo(weight, targetWeight, weightStatus, lastTime));
        }
        return Optional.empty();
    }

    @Override
    public WeightStatus determineHorsesWeightStatus(EQHorse horse) {
        double targetWeight = this.getTargetWeight(horse);
        double weight = this.getHorsesWeight(horse);
        return this.determineHorsesWeightStatus(targetWeight, weight);
    }

    private WeightStatus determineHorsesWeightStatus(double targetWeight, double weight) {
        if (weight < PercentageUtils.of(targetWeight, HorseWeightSettings.getUnderweightPercentageThreshold())) {
            return WeightStatus.UNDERWEIGHT;
        }
        if (weight > PercentageUtils.of(targetWeight, HorseWeightSettings.getOverweightPercentageThreshold())) {
            return WeightStatus.OVERWEIGHT;
        }
        return WeightStatus.OPTIMAL;
    }

    @Override
    public double getTargetWeight(EQHorse horse) {
        double weightPercentage = this.ageSettingSession.getFinalWeightPercentage(horse);
        return PercentageUtils.of(horse.getBaseWeight().getValue().doubleValue(), weightPercentage);
    }
}

