/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.wormer;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSession;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseWormerAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseSession horseSession;

    public HorseWormerAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean isWormed() {
        if (this.horse.getWormerDate() == null) {
            return false;
        }
        if (this.horse.getWormerExpiry() == null) {
            return true;
        }
        return DateUtils.isInFuture(this.horse.getWormerExpiry());
    }

    public void worm(Duration duration) {
        Date date = new Date();
        this.horse.setWormerDate(date);
        Date expiry = DateUtils.futureDurationOffset(date, duration);
        this.horse.setWormerExpiry(expiry);
        this.horse.save();
    }

    public Optional<Duration> getDurationSinceWormed() {
        Date wormDate = this.horse.getWormerDate();
        if (wormDate == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationSince(wormDate));
    }

    public Optional<Duration> getDurationUntilExpiry() {
        Date expiry = this.horse.getWormerExpiry();
        if (expiry == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationUntil(expiry));
    }
}

