/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horsecreate;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.height.HorseHeight;
import com.equestricraft.core.horsecreate.HorseCreateBodyOption;
import java.util.List;
import java.util.UUID;

public class HorseCreateBodyOptionDatabase
implements RepositoryDatasource<HorseCreateBodyOption, UUID> {
    @Override
    public List<HorseCreateBodyOption> retrieveAll() {
        return Query.selectAllFrom("HORSE_CREATE_BODY_OPTION").where(QueryColumn.column("ENABLED", true)).orderBy("LABEL ASC").getList(this::getFromResultRow);
    }

    private HorseCreateBodyOption getFromResultRow(ResultRow row) {
        UUID id = row.getUuid("ID");
        String label = row.getString("LABEL");
        double heightBlocks = row.getDouble("HEIGHT_BLOCKS");
        double weightKg = row.getDouble("WEIGHT_KG");
        return new HorseCreateBodyOption(id, label, HorseHeight.ofMeters(heightBlocks), weightKg);
    }
}

