/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class SimpleHttp {
    private static final SimpleHttp instance = new SimpleHttp();
    private static final String REQUEST_GET = "GET";

    public static SimpleHttp getInstance() {
        return instance;
    }

    private SimpleHttp() {
    }

    public String getString(String path) throws IOException {
        String inputLine;
        URL url = new URL(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(REQUEST_GET);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder content = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        connection.disconnect();
        return content.toString();
    }

    public Boolean getBoolean(String path) throws IOException {
        return Boolean.parseBoolean(this.getString(path));
    }

    public Integer getInteger(String path) throws IOException {
        return Integer.parseInt(this.getString(path));
    }
}

