/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.i18n;

import com.equestricraft.base.database.Database;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18nEditRepository;
import com.equestricraft.common.i18n.I18nEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class ServerI18nDatasource
implements I18nEditRepository {
    @Service
    public Database database;
    private static final String COLUMN_RESOURCE_KEY = "RESOURCE_KEY";
    private static final String COLUMN_RESOURCE_VALUE = "RESOURCE_VALUE";

    @Override
    public List<I18nEntity> getResourceEdits() {
        return Query.selectAllFrom("I18N_RESOURCE").getList(this::getFromResultRow);
    }

    private I18nEntity getFromResultRow(ResultRow row) {
        String key = row.getString(COLUMN_RESOURCE_KEY);
        String value = row.getString(COLUMN_RESOURCE_VALUE);
        return new I18nEntity(key, value);
    }

    @Override
    public int removeResourcesNotInList(Set<String> keys2) {
        int deleted = 0;
        try (PreparedStatement s = this.database.getSQLConnection().prepareStatement("SELECT RESOURCE_KEY FROM I18N_RESOURCE", 1004, 1008);
             ResultSet set2 = s.executeQuery();){
            while (set2.next()) {
                String key = set2.getString(1);
                if (keys2.contains(key)) continue;
                set2.deleteRow();
                ++deleted;
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
        return deleted;
    }
}

