/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.i18n.prefix;

import com.equestricraft.base.database.Database;
import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.prefix.I18nPrefixEditRepository;
import com.equestricraft.common.i18n.prefix.I18nPrefixEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class ServerI18nPrefixDatasource
implements I18nPrefixEditRepository {
    @Service
    private Database database;
    private static final String COLUMN_RESOURCE_KEY_PATTERN = "RESOURCE_KEY_PATTERN";
    private static final String COLUMN_PREFIX = "PREFIX";

    @Override
    public List<I18nPrefixEntity> getPrefixEdits() {
        return Query.selectAllFrom("I18N_RESOURCE_PREFIX").getList(this::getFromResultRow);
    }

    private I18nPrefixEntity getFromResultRow(ResultRow row) {
        String pattern = row.getString(COLUMN_RESOURCE_KEY_PATTERN);
        String value = row.getString(COLUMN_PREFIX);
        return new I18nPrefixEntity(pattern, value);
    }

    @Override
    public int removePrefixesNotInList(Set<String> prefixKeyPatterns) {
        int deleted = 0;
        try (PreparedStatement s = this.database.getSQLConnection().prepareStatement("SELECT RESOURCE_KEY_PATTERN FROM I18N_RESOURCE_PREFIX", 1004, 1008);
             ResultSet set2 = s.executeQuery();){
            while (set2.next()) {
                String key = set2.getString(1);
                if (prefixKeyPatterns.contains(key)) continue;
                set2.deleteRow();
                ++deleted;
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
        return deleted;
    }
}

