/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness;

import com.equestricraft.api.common.APIIllnessEffectDto;
import com.equestricraft.api.common.APIIllnessSymptomDto;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.symptom.APIIllnessSymptomDtoImpl;
import com.equestricraft.core.illness.symptom.IllnessSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptomMapping;
import java.util.List;

public class APIIllnessEffectDtoImpl
implements APIIllnessEffectDto {
    private final IllnessEffect illnessEffect;

    public APIIllnessEffectDtoImpl(IllnessEffect illnessEffect) {
        this.illnessEffect = illnessEffect;
    }

    @Override
    public String getName() {
        return this.illnessEffect.getName();
    }

    @Override
    public boolean isContagious() {
        return this.illnessEffect.isContagious();
    }

    @Override
    public boolean isCanCureAtEnd() {
        return this.illnessEffect.getCurePercentageProbability() > 0.0;
    }

    @Override
    public boolean isCanKillAtEnd() {
        return this.illnessEffect.getKillPercentageProbability() > 0.0;
    }

    @Override
    public String getSeverity() {
        return this.illnessEffect.getSeverity().name();
    }

    @Override
    public List<APIIllnessSymptomDto> getSymptoms() {
        return this.illnessEffect.getSymptoms().stream().map(IllnessSymptomMapping::getSymptom).map(s -> new APIIllnessSymptomDtoImpl((IllnessSymptom)s)).toList();
    }

    public String toString() {
        return this.getName();
    }
}

