/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.illness.IllnessDegreeRequirement;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessMedicine;
import com.equestricraft.core.illness.condition.IllnessCondition;
import java.util.List;
import java.util.Objects;

public class Illness
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String identifier;
    private final String description;
    private final String messageForTrainedPlayers;
    private final double baseProbability;
    private final int cureImmunityBoostPercentage;
    private final int contagiousRange;
    private final int immunityScaleTimeHours;
    private final int initialSpeedPercentageTolerance;
    private final boolean diagnosisNeeded;
    private final double diagnosisCost;
    private final boolean active;
    private List<IllnessMedicine> medicines;
    private List<IllnessCondition> illnessConditionList;
    private List<IllnessEffect> illnessEffects;
    private List<IllnessDegreeRequirement> illnessDegreeRequirements;
    private final String onApplyScript;
    private final String onCureScript;
    private List<Integer> jobIds;

    public Illness(int id, String name, String identifier, String description, String messageForTrainedPlayers, double baseProbability, int cureImmunityBoostPercentage, int contagiousRange, int immunityScaleTimeHours, int initialSpeedPercentageTolerance, boolean diagnosisNeeded, double diagnosisCost, boolean active, String onApplyScript, String onCureScript) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.messageForTrainedPlayers = messageForTrainedPlayers;
        this.baseProbability = baseProbability;
        this.cureImmunityBoostPercentage = cureImmunityBoostPercentage;
        this.contagiousRange = contagiousRange;
        this.immunityScaleTimeHours = immunityScaleTimeHours;
        this.initialSpeedPercentageTolerance = initialSpeedPercentageTolerance;
        this.diagnosisNeeded = diagnosisNeeded;
        this.diagnosisCost = diagnosisCost;
        this.active = active;
        this.onApplyScript = onApplyScript;
        this.onCureScript = onCureScript;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessageForTrainedPlayers() {
        return this.messageForTrainedPlayers;
    }

    public double getBaseProbability() {
        return this.baseProbability;
    }

    public int getCureImmunityBoostPercentage() {
        return this.cureImmunityBoostPercentage;
    }

    public int getContagiousRange() {
        return this.contagiousRange;
    }

    public int getImmunityScaleTimeHours() {
        return this.immunityScaleTimeHours;
    }

    public int getInitialSpeedPercentageTolerance() {
        return this.initialSpeedPercentageTolerance;
    }

    public boolean isDiagnosisNeeded() {
        return this.diagnosisNeeded;
    }

    public double getDiagnosisCost() {
        return this.diagnosisCost;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<IllnessMedicine> getMedicines() {
        return this.medicines;
    }

    protected void setMedicines(List<IllnessMedicine> medicines) {
        this.medicines = medicines;
    }

    public List<IllnessCondition> getIllnessConditionList() {
        return this.illnessConditionList;
    }

    protected void setIllnessConditionList(List<IllnessCondition> illnessConditionList) {
        this.illnessConditionList = illnessConditionList;
    }

    public List<IllnessEffect> getIllnessEffects() {
        return this.illnessEffects;
    }

    protected void setIllnessEffects(List<IllnessEffect> illnessEffects) {
        this.illnessEffects = illnessEffects;
    }

    public List<IllnessDegreeRequirement> getIllnessDegreeRequirements() {
        return this.illnessDegreeRequirements;
    }

    protected void setIllnessDegreeRequirements(List<IllnessDegreeRequirement> illnessDegreeRequirements) {
        this.illnessDegreeRequirements = illnessDegreeRequirements;
    }

    public String getOnApplyScript() {
        return this.onApplyScript;
    }

    public String getOnCureScript() {
        return this.onCureScript;
    }

    public List<Integer> getJobIds() {
        return this.jobIds;
    }

    protected void setJobIds(List<Integer> jobIds) {
        this.jobIds = jobIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Illness illness = (Illness)o;
        return this.id == illness.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id + " - " + this.name;
    }
}

