/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.DegreeClassification;
import com.equestricraft.common.Dominance;
import com.equestricraft.common.IllnessConditionType;
import com.equestricraft.common.IllnessSeverity;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessDegreeRequirement;
import com.equestricraft.core.illness.IllnessEffect;
import com.equestricraft.core.illness.IllnessEffectSymptom;
import com.equestricraft.core.illness.IllnessMedicine;
import com.equestricraft.core.illness.condition.IllnessAgeCondition;
import com.equestricraft.core.illness.condition.IllnessAlleleCondition;
import com.equestricraft.core.illness.condition.IllnessCondition;
import com.equestricraft.core.illness.condition.IllnessNutrientCondition;
import com.equestricraft.core.illness.condition.IllnessScriptCondition;
import com.equestricraft.core.nutrient.Nutrient;
import java.util.List;
import java.util.UUID;

public class IllnessDatabase
implements RepositoryDatasource<Illness, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String MESSAGE_FOR_TRAINED_PLAYERS = "MESSAGE_FOR_TRAINED_PLAYERS";
    private static final String COLUMN_BASE_PROBABILITY = "BASE_PROBABILITY";
    private static final String COLUMN_CURE_IMMUNITY_BOOST_PERCENTAGE = "CURE_IMMUNITY_BOOST_PERCENTAGE";
    private static final String COLUMN_CONTAGIOUS_RANGE = "CONTAGIOUS_RANGE";
    private static final String COLUMN_IMMUNITY_SCALE_TIME_HOURS = "IMMUNITY_SCALE_TIME_HOURS";
    private static final String COLUMN_INITIAL_SPEED_PERCENTAGE_TOLERANCE = "INITIAL_SPEED_PERCENTAGE_TOLERANCE";
    private static final String COLUMN_DIAGNOSIS_NEEDED = "DIAGNOSIS_NEEDED";
    private static final String COLUMN_DIAGNOSIS_COST = "DIAGNOSIS_COST";
    private static final String COLUMN_ACTIVE = "ACTIVE";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_ON_APPLY_SCRIPT = "ON_APPLY_SCRIPT";
    private static final String COLUMN_ON_CURE_SCRIPT = "ON_CURE_SCRIPT";
    private static final String COLUMN_ILLNESS_ID = "ILLNESS_ID";
    private static final String COLUMN_MEDICINE_ID = "MEDICINE_ID";
    private static final String COLUMN_IMMUNITY_PERCENTAGE_GAIN = "IMMUNITY_PERCENTAGE_GAIN";
    private static final String COLUMN_CURING_PERCENTAGE_GAIN = "CURING_PERCENTAGE_GAIN";
    private static final String COLUMN_UNITS_NEEDED = "UNITS_NEEDED";
    private static final String DELAY_BETWEEN_UNITS_HOURS = "DELAY_BETWEEN_UNITS_HOURS";
    private static final String COLUMN_PROBABILITY_INCREASE = "PROBABILITY_INCREASE";
    private static final String COLUMN_MANDATORY = "MANDATORY";
    private static final String COLUMN_CONDITION_TYPE = "CONDITION_TYPE";
    private static final String COLUMN_MINIMUM_AGE_MONTHS = "MINIMUM_AGE_MONTHS";
    private static final String COLUMN_MAXIMUM_AGE_MONTHS = "MAXIMUM_AGE_MONTHS";
    private static final String COLUMN_SCRIPT = "SCRIPT";
    private static final String COLUMN_NUTRIENT_IDENTIFIER = "NUTRIENT_IDENTIFIER";
    private static final String COLUMN_NUTRIENT_MINIMUM_VALUE = "NUTRIENT_MINIMUM_VALUE";
    private static final String COLUMN_NUTRIENT_MAXIMUM_VALUE = "NUTRIENT_MAXIMUM_VALUE";
    private static final String COLUMN_ALLELE_ID = "ALLELE_ID";
    private static final String COLUMN_DOMINANCE = "DOMINANCE";
    private static final String COLUMN_CONTAGIOUS = "CONTAGIOUS";
    private static final String COLUMN_PRE_CONDITION_SCRIPT = "PRE_CONDITION_SCRIPT";
    private static final String COLUMN_START_DURATION_HOURS = "START_DURATION_HOURS";
    private static final String COLUMN_END_DURATION_HOURS = "END_DURATION_HOURS";
    private static final String COLUMN_SEVERITY = "SEVERITY";
    private static final String COLUMN_CURE_PERCENTAGE_PROBABILITY = "CURE_PERCENTAGE_PROBABILITY";
    private static final String COLUMN_KILL_PERCENTAGE_PROBABILITY = "KILL_PERCENTAGE_PROBABILITY";
    private static final String COLUMN_ON_END_SCRIPT = "ON_END_SCRIPT";
    private static final String COLUMN_ILLNESS_EFFECT_ID = "ILLNESS_EFFECT_ID";
    private static final String COLUMN_ILLNESS_SYMPTOM_ID = "ILLNESS_SYMPTOM_ID";
    private static final String COLUMN_EFFECTS_PERCENTAGE = "EFFECTS_PERCENTAGE";
    private static final String COLUMN_UNIVERSITY_DEGREE_ID = "UNIVERSITY_DEGREE_ID";
    private static final String COLUMN_MINIMUM_CLASSIFICATION = "MINIMUM_CLASSIFICATION";
    private static final String COLUMN_JOB_ID = "JOB_ID";

    @Override
    public List<Illness> retrieveAll() {
        return Query.selectAllFrom("ILLNESS").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getIllnessFromResultRow);
    }

    private Illness getIllnessFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String messageForTrainedPlayers = row.getString(MESSAGE_FOR_TRAINED_PLAYERS);
        double baseProbability = row.getDouble(COLUMN_BASE_PROBABILITY);
        int cureImmunityBoostPercentage = row.getInt(COLUMN_CURE_IMMUNITY_BOOST_PERCENTAGE);
        int contagiousRange = row.getInt(COLUMN_CONTAGIOUS_RANGE);
        int immunityScaleTimeHours = row.getInt(COLUMN_IMMUNITY_SCALE_TIME_HOURS);
        int initialSpeedPercentageTolerance = row.getInt(COLUMN_INITIAL_SPEED_PERCENTAGE_TOLERANCE);
        boolean diagnosisNeeded = row.getBoolean(COLUMN_DIAGNOSIS_NEEDED);
        double diagnosisCost = row.getDouble(COLUMN_DIAGNOSIS_COST);
        boolean active = row.getBoolean(COLUMN_ACTIVE);
        String onApplyScript = row.getString(COLUMN_ON_APPLY_SCRIPT);
        String onCureScript = row.getString(COLUMN_ON_CURE_SCRIPT);
        Illness illness = new Illness(id, name, identifier, description, messageForTrainedPlayers, baseProbability, cureImmunityBoostPercentage, contagiousRange, immunityScaleTimeHours, initialSpeedPercentageTolerance, diagnosisNeeded, diagnosisCost, active, onApplyScript, onCureScript);
        illness.setMedicines(this.getMedicineIdsForIllness(illness));
        illness.setIllnessConditionList(this.getConditionsForIllness(illness));
        illness.setIllnessEffects(this.getEffectsForIllness(illness));
        illness.setIllnessDegreeRequirements(this.getDegreeRequirementsForIllness(illness));
        illness.setJobIds(this.getJobIdsForIllness(illness));
        return illness;
    }

    private List<IllnessMedicine> getMedicineIdsForIllness(Illness illness) {
        return Query.selectAllFrom("ILLNESS_MEDICINE").where(QueryColumn.column(COLUMN_ILLNESS_ID, illness.getId())).getList(r -> this.getIllnessMedicineFromResultRow(r, illness));
    }

    private IllnessMedicine getIllnessMedicineFromResultRow(ResultRow row, Illness illness) {
        int medicineId = row.getInt(COLUMN_MEDICINE_ID);
        int immunityPercentageGain = row.getInt(COLUMN_IMMUNITY_PERCENTAGE_GAIN);
        int curingPercentageGain = row.getInt(COLUMN_CURING_PERCENTAGE_GAIN);
        int unitsNeeded = row.getInt(COLUMN_UNITS_NEEDED);
        int delayBetweenUnitsHours = row.getInt(DELAY_BETWEEN_UNITS_HOURS);
        return new IllnessMedicine(medicineId, illness, immunityPercentageGain, curingPercentageGain, unitsNeeded, delayBetweenUnitsHours);
    }

    private List<IllnessCondition> getConditionsForIllness(Illness illness) {
        List<BasicIllnessCondition> basicConditions = Query.selectAllFrom("ILLNESS_CONDITION").where(QueryColumn.column(COLUMN_ILLNESS_ID, illness.getId())).getList(r -> this.getIllnessConditionFromResultRow(r, illness));
        return basicConditions.stream().map(condition -> switch (condition.type()) {
            default -> throw new IncompatibleClassChangeError();
            case IllnessConditionType.AGE -> this.getAgeCondition((BasicIllnessCondition)condition);
            case IllnessConditionType.SCRIPT -> this.getScriptCondition((BasicIllnessCondition)condition);
            case IllnessConditionType.NUTRIENT -> this.getNutrientCondition((BasicIllnessCondition)condition);
            case IllnessConditionType.ALLELE -> this.getAlleleCondition((BasicIllnessCondition)condition);
        }).toList();
    }

    private BasicIllnessCondition getIllnessConditionFromResultRow(ResultRow row, Illness illness) {
        UUID id = row.getUuid(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        double probabilityIncrease = row.getDouble(COLUMN_PROBABILITY_INCREASE);
        boolean mandatory = row.getBoolean(COLUMN_MANDATORY);
        IllnessConditionType type = row.getEnum(COLUMN_CONDITION_TYPE, IllnessConditionType.class);
        return new BasicIllnessCondition(id, name, illness, probabilityIncrease, mandatory, type);
    }

    private IllnessAgeCondition getAgeCondition(BasicIllnessCondition basicCondition) {
        return Query.selectAllFrom("ILLNESS_AGE_CONDITION").where(QueryColumn.column(COLUMN_ID, basicCondition.id())).getSingle(row -> this.getAgeConditionFromResultRow(basicCondition, row)).orElseThrow();
    }

    private IllnessAgeCondition getAgeConditionFromResultRow(BasicIllnessCondition basicCondition, ResultRow row) {
        Integer minimumAgeMonths = row.getNullableInt(COLUMN_MINIMUM_AGE_MONTHS);
        Integer maximumAgeMonths = row.getNullableInt(COLUMN_MAXIMUM_AGE_MONTHS);
        return new IllnessAgeCondition(basicCondition.id(), basicCondition.name(), basicCondition.illness(), basicCondition.probabilityIncrease(), basicCondition.mandatory(), minimumAgeMonths, maximumAgeMonths);
    }

    private IllnessScriptCondition getScriptCondition(BasicIllnessCondition basicCondition) {
        return Query.selectAllFrom("ILLNESS_SCRIPT_CONDITION").where(QueryColumn.column(COLUMN_ID, basicCondition.id())).getSingle(row -> this.getScriptConditionFromResultRow(basicCondition, row)).orElseThrow();
    }

    private IllnessScriptCondition getScriptConditionFromResultRow(BasicIllnessCondition basicCondition, ResultRow row) {
        String script = row.getString(COLUMN_SCRIPT);
        return new IllnessScriptCondition(basicCondition.id(), basicCondition.name(), basicCondition.illness(), basicCondition.probabilityIncrease(), basicCondition.mandatory(), script);
    }

    private IllnessNutrientCondition getNutrientCondition(BasicIllnessCondition basicCondition) {
        return Query.selectAllFrom("ILLNESS_NUTRIENT_CONDITION").where(QueryColumn.column(COLUMN_ID, basicCondition.id())).getSingle(row -> this.getNutrientConditionFromResultRow(basicCondition, row)).orElseThrow();
    }

    private IllnessNutrientCondition getNutrientConditionFromResultRow(BasicIllnessCondition basicCondition, ResultRow row) {
        Nutrient nutrient = row.getEnum(COLUMN_NUTRIENT_IDENTIFIER, Nutrient.class);
        Double minimumValue = row.getNullableDouble(COLUMN_NUTRIENT_MINIMUM_VALUE);
        Double maximumValue = row.getNullableDouble(COLUMN_NUTRIENT_MAXIMUM_VALUE);
        return new IllnessNutrientCondition(basicCondition.id(), basicCondition.name(), basicCondition.illness(), basicCondition.probabilityIncrease(), basicCondition.mandatory(), nutrient, minimumValue, maximumValue);
    }

    private IllnessAlleleCondition getAlleleCondition(BasicIllnessCondition basicCondition) {
        return Query.selectAllFrom("ILLNESS_ALLELE_CONDITION").where(QueryColumn.column(COLUMN_ID, basicCondition.id())).getSingle(row -> this.getAlleleConditionFromResultRow(basicCondition, row)).orElseThrow();
    }

    private IllnessAlleleCondition getAlleleConditionFromResultRow(BasicIllnessCondition basicCondition, ResultRow row) {
        int alleleId = row.getInt(COLUMN_ALLELE_ID);
        Dominance dominance = row.getEnum(COLUMN_DOMINANCE, Dominance.class);
        return new IllnessAlleleCondition(basicCondition.id(), basicCondition.name(), basicCondition.illness(), basicCondition.probabilityIncrease(), basicCondition.mandatory(), alleleId, dominance);
    }

    private List<IllnessEffect> getEffectsForIllness(Illness illness) {
        return Query.selectAllFrom("ILLNESS_EFFECT").where(QueryColumn.column(COLUMN_ILLNESS_ID, illness.getId())).getList(r -> this.getIllnessEffectFromResultRow(r, illness));
    }

    private IllnessEffect getIllnessEffectFromResultRow(ResultRow row, Illness illness) {
        UUID id = row.getUuid(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        boolean contagious = row.getBoolean(COLUMN_CONTAGIOUS);
        String preConditionScript = row.getString(COLUMN_PRE_CONDITION_SCRIPT);
        int startDurationHours = row.getInt(COLUMN_START_DURATION_HOURS);
        Integer endDurationHours = row.getNullableInt(COLUMN_END_DURATION_HOURS);
        IllnessSeverity severity = row.getEnum(COLUMN_SEVERITY, IllnessSeverity.class);
        double curePercentageProbability = row.getDouble(COLUMN_CURE_PERCENTAGE_PROBABILITY);
        double killPercentageProbability = row.getDouble(COLUMN_KILL_PERCENTAGE_PROBABILITY);
        String onEndScript = row.getString(COLUMN_ON_END_SCRIPT);
        IllnessEffect effect = new IllnessEffect(id, name, illness, contagious, preConditionScript, startDurationHours, endDurationHours, severity, curePercentageProbability, killPercentageProbability, onEndScript);
        List<IllnessEffectSymptom> symptoms = this.getIllnessEffectSymptomsForIllnessEffect(effect);
        effect.setEffectSymptoms(symptoms);
        return effect;
    }

    private List<IllnessEffectSymptom> getIllnessEffectSymptomsForIllnessEffect(IllnessEffect effect) {
        return Query.selectAllFrom("ILLNESS_EFFECT_SYMPTOM").where(QueryColumn.column(COLUMN_ILLNESS_EFFECT_ID, effect.getId())).getList(r -> this.getIllnessStageSymptomFromResultRow(r, effect));
    }

    private IllnessEffectSymptom getIllnessStageSymptomFromResultRow(ResultRow row, IllnessEffect effect) {
        int symptomId = row.getInt(COLUMN_ILLNESS_SYMPTOM_ID);
        double effectsPercentage = row.getDouble(COLUMN_EFFECTS_PERCENTAGE);
        return new IllnessEffectSymptom(symptomId, effect, effectsPercentage);
    }

    private List<IllnessDegreeRequirement> getDegreeRequirementsForIllness(Illness illness) {
        return Query.selectAllFrom("ILLNESS_DEGREE_REQUIREMENT").where(QueryColumn.column(COLUMN_ILLNESS_ID, illness.getId())).getList(r -> this.getIllnessDegreeRequirementFromResultRow(r, illness));
    }

    private IllnessDegreeRequirement getIllnessDegreeRequirementFromResultRow(ResultRow row, Illness illness) {
        int universityDegreeId = row.getInt(COLUMN_UNIVERSITY_DEGREE_ID);
        DegreeClassification degreeClassification = row.getEnum(COLUMN_MINIMUM_CLASSIFICATION, DegreeClassification.class);
        return new IllnessDegreeRequirement(universityDegreeId, illness, degreeClassification);
    }

    private List<Integer> getJobIdsForIllness(Illness illness) {
        return Query.selectAllFrom("ILLNESS_JOB").where(QueryColumn.column(COLUMN_ILLNESS_ID, illness.getId())).getList(r -> r.getInt(COLUMN_JOB_ID));
    }

    private record BasicIllnessCondition(UUID id, String name, Illness illness, double probabilityIncrease, boolean mandatory, IllnessConditionType type) {
    }
}

