/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness;

import com.equestricraft.common.IllnessSeverity;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessEffectSymptom;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class IllnessEffect {
    private final UUID id;
    private final String name;
    private final Illness illness;
    private final boolean contagious;
    private final String preConditionScript;
    private final int startDurationHours;
    private final Integer endDurationHours;
    private final IllnessSeverity severity;
    private List<IllnessEffectSymptom> effectSymptoms;
    private final double curePercentageProbability;
    private final double killPercentageProbability;
    private final String onEndScript;

    public IllnessEffect(UUID id, String name, Illness illness, boolean contagious, String preConditionScript, int startDurationHours, Integer endDurationHours, IllnessSeverity severity, double curePercentageProbability, double killPercentageProbability, String onEndScript) {
        this.id = id;
        this.name = name;
        this.illness = illness;
        this.contagious = contagious;
        this.preConditionScript = preConditionScript;
        this.startDurationHours = startDurationHours;
        this.endDurationHours = endDurationHours;
        this.severity = severity;
        this.curePercentageProbability = curePercentageProbability;
        this.killPercentageProbability = killPercentageProbability;
        this.onEndScript = onEndScript;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Illness getIllness() {
        return this.illness;
    }

    public boolean isContagious() {
        return this.contagious;
    }

    public String getPreConditionScript() {
        return this.preConditionScript;
    }

    public int getStartDurationHours() {
        return this.startDurationHours;
    }

    public Integer getEndDurationHours() {
        return this.endDurationHours;
    }

    public IllnessSeverity getSeverity() {
        return this.severity;
    }

    public List<IllnessEffectSymptom> getSymptoms() {
        return this.effectSymptoms;
    }

    protected void setEffectSymptoms(List<IllnessEffectSymptom> effectSymptoms) {
        this.effectSymptoms = effectSymptoms;
    }

    public double getCurePercentageProbability() {
        return this.curePercentageProbability;
    }

    public double getKillPercentageProbability() {
        return this.killPercentageProbability;
    }

    public String getOnEndScript() {
        return this.onEndScript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IllnessEffect that = (IllnessEffect)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

