/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness;

import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessSession;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.player.ECPlayer;
import java.util.Optional;

public class IllnessSessionImpl
implements IllnessSession {
    @Override
    public boolean canSeeAdvancedIllnessInformation(ECPlayer player, Illness illness) {
        return !this.doesJobCheckBlock(player, illness) && !this.doesDegreeCheckBlock(player, illness);
    }

    private boolean doesDegreeCheckBlock(ECPlayer player, Illness illness) {
        if (illness.getIllnessDegreeRequirements().isEmpty()) {
            return false;
        }
        return illness.getIllnessDegreeRequirements().stream().noneMatch(d -> player.getUniversity().hasBeenAwardedAtLeastClassification(d.getDegreeId(), d.getMinimumClassification()));
    }

    private boolean doesJobCheckBlock(ECPlayer player, Illness illness) {
        if (illness.getJobIds().isEmpty()) {
            return false;
        }
        Optional<Job> playersCurrentJob = player.getJob().getCurrent();
        return illness.getJobIds().stream().noneMatch(j -> playersCurrentJob.filter(cj -> cj.getId() == j.intValue()).isPresent());
    }
}

