/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.illness.symptom;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.illness.symptom.IllnessSymptom;
import com.equestricraft.core.illness.symptom.IllnessSymptomActionPercentage;
import com.equestricraft.core.illness.symptom.IllnessSymptomBlood;
import com.equestricraft.core.illness.symptom.IllnessSymptomNutrient;
import com.equestricraft.core.nutrient.Nutrient;
import java.util.List;

public class IllnessSymptomDatabase
implements RepositoryDatasource<IllnessSymptom, Integer> {
    @Override
    public List<IllnessSymptom> retrieveAll() {
        return Query.selectAllFrom("ILLNESS_SYMPTOM").where(QueryColumn.column("PUBLISHED", true)).getList(this::getIllnessSymptomFromResultRow);
    }

    private IllnessSymptom getIllnessSymptomFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String identifier = row.getString("IDENTIFIER");
        String description = row.getString("DESCRIPTION");
        int speedPercentage = row.getInt("SPEED_PERCENTAGE");
        int jumpPercentage = row.getInt("JUMP_PERCENTAGE");
        int metabolismPercentage = row.getInt("METABOLISM_PERCENTAGE");
        int memoryReductionPercentage = row.getInt("MEMORY_PERCENTAGE");
        int fertilityPercentage = row.getInt("FERTILITY_PERCENTAGE");
        int appetitePercentage = row.getInt("APPETITE_PERCENTAGE");
        IllnessSymptomBlood blood = this.getBloodForSymptom(id);
        List<IllnessSymptomNutrient> nutrients = this.getNutrientsForSymptom(id);
        double systolicBloodPressurePercentage = row.getDouble("SYSTOLIC_BLOOD_PRESSURE_PERCENTAGE");
        double diastolicBloodPressurePercentage = row.getDouble("DIASTOLIC_BLOOD_PRESSURE_PERCENTAGE");
        double heartRatePercentage = row.getDouble("HEART_RATE_PERCENTAGE");
        double restlessnessPercentage = row.getDouble("RESTLESSNESS_PERCENTAGE");
        double spookinessPercentage = row.getDouble("SPOOKINESS_PERCENTAGE");
        double obediencePercentage = row.getDouble("OBEDIENCE_PERCENTAGE");
        List<IllnessSymptomActionPercentage> actionPercentages = this.getActionPercentagesForSymptom(id);
        return new IllnessSymptom(id, name, identifier, description, speedPercentage, jumpPercentage, metabolismPercentage, fertilityPercentage, memoryReductionPercentage, appetitePercentage, blood, nutrients, systolicBloodPressurePercentage, diastolicBloodPressurePercentage, heartRatePercentage, restlessnessPercentage, spookinessPercentage, obediencePercentage, actionPercentages);
    }

    private IllnessSymptomBlood getBloodForSymptom(int illnessStageId) {
        return Query.selectAllFrom("ILLNESS_SYMPTOM_BLOOD").where(QueryColumn.column("ILLNESS_SYMPTOM_ID", illnessStageId)).getSingle(this::getIllnessSymptomBloodFromResultRow).orElse(null);
    }

    private List<IllnessSymptomNutrient> getNutrientsForSymptom(int illnessStageId) {
        return Query.selectAllFrom("ILLNESS_SYMPTOM_NUTRIENT").where(QueryColumn.column("ILLNESS_SYMPTOM_ID", illnessStageId)).getList(this::getIllnessSymptomNutrientFromResultRow);
    }

    private IllnessSymptomNutrient getIllnessSymptomNutrientFromResultRow(ResultRow row) {
        Nutrient nutrient = row.getEnum("NUTRIENT_IDENTIFIER", Nutrient.class);
        int percentage = row.getInt("PERCENTAGE");
        return new IllnessSymptomNutrient(nutrient, percentage);
    }

    private IllnessSymptomBlood getIllnessSymptomBloodFromResultRow(ResultRow row) {
        int redBloodCellPercentage = row.getInt("RED_BLOOD_CELL_PERCENTAGE");
        int whiteBloodCellPercentage = row.getInt("WHITE_BLOOD_CELL_PERCENTAGE");
        int plateletsPercentage = row.getInt("PLATELETS_PERCENTAGE");
        int electrolytesPercentage = row.getInt("ELECTROLYTES_PERCENTAGE");
        int enzymesPercentage = row.getInt("ENZYMES_PERCENTAGE");
        int proteinPercentage = row.getInt("PROTEIN_PERCENTAGE");
        int oxygenPercentage = row.getInt("OXYGEN_PERCENTAGE");
        int carbonDioxidePercentage = row.getInt("CARBON_DIOXIDE_PERCENTAGE");
        int nitrogenPercentage = row.getInt("NITROGEN_PERCENTAGE");
        return new IllnessSymptomBlood(redBloodCellPercentage, whiteBloodCellPercentage, plateletsPercentage, electrolytesPercentage, enzymesPercentage, proteinPercentage, oxygenPercentage, carbonDioxidePercentage, nitrogenPercentage);
    }

    private List<IllnessSymptomActionPercentage> getActionPercentagesForSymptom(int symptomId) {
        return Query.selectAllFrom("ILLNESS_SYMPTOM_ACTION_PERCENTAGE").where(QueryColumn.column("SYMPTOM_ID", symptomId)).getList(this::getIllnessSymptomActionPercentageFromResultRow);
    }

    private IllnessSymptomActionPercentage getIllnessSymptomActionPercentageFromResultRow(ResultRow row) {
        String actionIdentifier = row.getString("ACTION_IDENTIFIER");
        double percentage = row.getDouble("PERCENTAGE");
        return new IllnessSymptomActionPercentage(actionIdentifier, percentage);
    }
}

