/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.interpolation;

import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.groovy.GroovyScript;
import com.equestricraft.logging.Log;
import groovy.lang.Binding;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringInterpolator {
    private static final Pattern interpolatedVariablePattern = Pattern.compile("\\$\\{([^}]*)}");
    private String string = null;
    private static final Log log = Log.getLogger(StringInterpolator.class.getName());

    public final String execute(String string) {
        this.string = string;
        return this.execute();
    }

    private String execute() {
        Objects.requireNonNull(this.string, "Must supply a string");
        if (this.string.isBlank()) {
            return this.string;
        }
        Matcher matcher = interpolatedVariablePattern.matcher(this.string);
        if (!matcher.find()) {
            return this.string;
        }
        matcher.reset();
        Binding binding = new Binding();
        binding.setVariable("global", new APIGlobalDtoImpl());
        binding.setVariable("config", new APIConfigDtoImpl());
        HashMap<String, Object> coreVariables = new HashMap<String, Object>(0);
        this.addCoreVariables(coreVariables);
        this.addVariablesToBinding(coreVariables, binding);
        HashMap<String, Object> additionalVariables = new HashMap<String, Object>(0);
        this.addAdditionalVariables(additionalVariables);
        this.addVariablesToBinding(additionalVariables, binding);
        StringBuilder resultString = new StringBuilder();
        while (matcher.find()) {
            Object resultObject;
            String script = matcher.group(1);
            try {
                resultObject = GroovyScript.run(script, binding);
                if (resultObject == null) {
                    resultObject = StringUtils.emptyString();
                }
            }
            catch (Exception ex) {
                log.error("Error interpolating string", ex);
                resultObject = "&cERROR&r";
            }
            String result = Matcher.quoteReplacement(resultObject.toString());
            matcher.appendReplacement(resultString, result);
        }
        matcher.appendTail(resultString);
        return resultString.toString();
    }

    private void addVariablesToBinding(Map<String, Object> variables, Binding binding) {
        for (Map.Entry<String, Object> data : variables.entrySet()) {
            StringInterpolator.ensureNotOnBinding(binding, data.getKey());
            binding.setVariable(data.getKey(), data.getValue());
        }
    }

    private static void ensureNotOnBinding(Binding binding, String name) {
        if (binding.hasVariable(name)) {
            throw new IllegalArgumentException(String.format("Variable '%s' is already on the binding", name));
        }
    }

    protected void addCoreVariables(Map<String, Object> coreVariables) {
    }

    protected void addAdditionalVariables(Map<String, Object> rootVariables) {
    }

    public String toString() {
        return this.execute();
    }
}

