/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.item;

import com.equestricraft.api.common.APIItemDto;
import com.equestricraft.api.common.APIItemsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.item.APIItemDtoImpl;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemRepository;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class APIItemsDtoImpl
extends MapAdapter<String, APIItemDto>
implements APIItemsDto {
    @Service
    private static ECItemRepository ecItemRepository;

    @Override
    public int size() {
        return ecItemRepository.getTotalSize();
    }

    @Override
    public APIItemDto get(Object key) {
        Optional<ECItem> item = ecItemRepository.findByIdentifier(key.toString());
        return item.map(APIItemDtoImpl::new).orElse(null);
    }

    @Override
    public Set<Map.Entry<String, APIItemDto>> entrySet() {
        return new EntrySet();
    }

    static final class EntrySet
    extends AbstractSet<Map.Entry<String, APIItemDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIItemDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return ecItemRepository.getTotalSize();
        }

        static final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIItemDto>> {
            private final Iterator<ECItem> iterator = ecItemRepository.iterator();

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIItemDto> next() {
                ECItem next = this.iterator.next();
                APIItemDtoImpl dto = new APIItemDtoImpl(next);
                return Map.entry(next.getIdentifier(), dto);
            }
        }
    }
}

