/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.item;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import java.util.List;
import java.util.UUID;

public abstract class AbstractItemDatabase {
    private static final String COLUMN_ITEM_ID = "ITEM_ID";
    private static final String COLUMN_TAG_ID = "TAG_ID";
    private static final String COLUMN_OFFSET_VALUE = "OFFSET_VALUE";
    private static final String COLUMN_REJECT_THRESHOLD = "REJECT_THRESHOLD";

    protected final List<ItemTag> getTags(ECItemDetails details) {
        return Query.selectAllFrom("ITEM_TAG").where(QueryColumn.column(COLUMN_ITEM_ID, details.id())).getList(this::getFromResultRow);
    }

    private ItemTag getFromResultRow(ResultRow row) {
        UUID tagId = row.getUuid(COLUMN_TAG_ID);
        double offsetValue = row.getDouble(COLUMN_OFFSET_VALUE);
        Double rejectThreshold = row.getNullableDouble(COLUMN_REJECT_THRESHOLD);
        return new ItemTag(tagId, offsetValue, rejectThreshold);
    }
}

