/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.item;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.item.ECItemType;
import com.equestricraft.core.item.ItemTag;
import java.util.List;
import java.util.Objects;

public abstract class ECItem
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final String identifier;
    private final String description;
    private final ECItemType typeDiscriminator;
    private final String modItemName;
    private final List<ItemTag> tags;

    protected ECItem(int id, String name, String identifier, String description, ECItemType typeDiscriminator, String modItemName, List<ItemTag> tags) {
        this.id = id;
        this.name = name;
        this.identifier = identifier;
        this.description = description;
        this.typeDiscriminator = typeDiscriminator;
        this.modItemName = modItemName;
        this.tags = tags;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public ECItemType getTypeDiscriminator() {
        return this.typeDiscriminator;
    }

    public String getModItemName() {
        return this.modItemName;
    }

    public List<ItemTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECItem ecItem = (ECItem)o;
        return this.id == ecItem.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

