/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.item;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ECItemType;
import com.equestricraft.core.medicine.MedicineDatabase;
import com.equestricraft.core.provision.ProvisionDatabase;
import com.equestricraft.core.tack.bonnet.BonnetDatabase;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.BootsDatabase;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.BridleDatabase;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.CinchDatabase;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.GirthDatabase;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HalterDatabase;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.pad.HorsePadDatabase;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.rein.HorseReinDatabase;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.saddle.HorseSaddleDatabase;
import com.equestricraft.core.tack.wraps.HorseWraps;
import com.equestricraft.core.tack.wraps.HorseWrapsDatabase;
import java.util.List;

public class ECItemDatabase
implements RepositoryDatasource<ECItem, Integer> {
    @Service
    private ProvisionDatabase provisionDatabase;
    @Service
    private MedicineDatabase medicineDatabase;
    @Service
    private BonnetDatabase bonnetDatabase;
    @Service
    private BootsDatabase bootsDatabase;
    @Service
    private BridleDatabase bridleDatabase;
    @Service
    private CinchDatabase cinchDatabase;
    @Service
    private GirthDatabase girthDatabase;
    @Service
    private HalterDatabase halterDatabase;
    @Service
    private HorsePadDatabase horsePadDatabase;
    @Service
    private HorseReinDatabase horseReinDatabase;
    @Service
    private HorseSaddleDatabase horseSaddleDatabase;
    @Service
    private HorseWrapsDatabase horseWrapsDatabase;

    @Override
    public List<ECItem> retrieveAll() {
        return Query.selectAllFrom("ITEM").getList(this::getFromResultRow);
    }

    private ECItem getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String identifier = row.getString("IDENTIFIER");
        String description = row.getString("DESCRIPTION");
        ECItemType type = row.getEnum("TYPE_DISCRIMINATOR", ECItemType.class);
        String modItemName = row.getString("MOD_ITEM_NAME");
        ECItemDetails item = new ECItemDetails(id, name, identifier, description, type, modItemName);
        return this.buildItem(item);
    }

    private ECItem buildItem(ECItemDetails details) {
        return switch (details.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ECItemType.MEDICINE -> this.medicineDatabase.getMedicineFromItem(details);
            case ECItemType.PROVISION -> this.provisionDatabase.getProvisionFromItem(details);
            case ECItemType.HORSE_BONNET -> (HorseBonnet)this.bonnetDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_BOOTS -> (HorseBoots)this.bootsDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_BRIDLE -> (HorseBridle)this.bridleDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_CINCH -> (HorseCinch)this.cinchDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_GIRTH -> (HorseGirth)this.girthDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_HALTER -> (HorseHalter)this.halterDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_PAD -> (HorsePad)this.horsePadDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_REIN -> (HorseRein)this.horseReinDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_SADDLE -> (HorseSaddle)this.horseSaddleDatabase.retrieveForDetails(details);
            case ECItemType.HORSE_WRAPS -> (HorseWraps)this.horseWrapsDatabase.retrieveForDetails(details);
        };
    }
}

