/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.item;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemDatabase;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.provision.ProvisionRepository;
import com.equestricraft.core.tack.bonnet.HorseBonnetRepository;
import com.equestricraft.core.tack.boots.HorseBootsRepository;
import com.equestricraft.core.tack.bridle.HorseBridleRepository;
import com.equestricraft.core.tack.cinch.HorseCinchRepository;
import com.equestricraft.core.tack.girth.HorseGirthRepository;
import com.equestricraft.core.tack.halter.HorseHalterRepository;
import com.equestricraft.core.tack.pad.HorsePadRepository;
import com.equestricraft.core.tack.rein.HorseReinRepository;
import com.equestricraft.core.tack.saddle.HorseSaddleRepository;
import com.equestricraft.core.tack.wraps.HorseWrapsRepository;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ECItemRepository
extends Repository<ECItem, Integer> {
    @Service
    private ECItemDatabase ecItemDatabase;
    @Service
    private ProvisionRepository provisionRepository;
    @Service
    private MedicineRepository medicineRepository;
    @Service
    private HorseBonnetRepository horseBonnetRepository;
    @Service
    private HorseBootsRepository horseBootsRepository;
    @Service
    private HorseBridleRepository horseBridleRepository;
    @Service
    private HorseCinchRepository horseCinchRepository;
    @Service
    private HorseGirthRepository horseGirthRepository;
    @Service
    private HorseHalterRepository horseHalterRepository;
    @Service
    private HorsePadRepository horsePadRepository;
    @Service
    private HorseReinRepository horseReinRepository;
    @Service
    private HorseSaddleRepository horseSaddleRepository;
    @Service
    private HorseWrapsRepository horseWrapsRepository;

    @Override
    protected RepositoryDatasource<ECItem, Integer> getDatasource() {
        return this.ecItemDatabase;
    }

    @Override
    protected void onLoad(List<ECItem> data) {
        this.provisionRepository.loadItems(data);
        this.medicineRepository.loadItems(data);
        this.horseBonnetRepository.loadItems(data);
        this.horseBootsRepository.loadItems(data);
        this.horseBridleRepository.loadItems(data);
        this.horseCinchRepository.loadItems(data);
        this.horseGirthRepository.loadItems(data);
        this.horseHalterRepository.loadItems(data);
        this.horsePadRepository.loadItems(data);
        this.horseReinRepository.loadItems(data);
        this.horseSaddleRepository.loadItems(data);
        this.horseWrapsRepository.loadItems(data);
    }

    @Override
    protected Function<ECItem, Object> getIndexFunction() {
        return ECItem::getIdentifier;
    }

    public Optional<ECItem> findByIdentifier(String identifier) {
        return this.findByIndexKeyIfExists(identifier);
    }
}

