/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.Argb;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobWork;
import java.util.List;
import java.util.UUID;

public class JobDatabase
implements RepositoryDatasource<Job, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_CHAT_TAG = "CHAT_TAG";
    private static final String COLUMN_COLOR = "COLOR";
    private static final String COLUMN_PARENT_JOB_ID = "PARENT_JOB_ID";
    private static final String COLUMN_DISCORD_ROLE_ID = "DISCORD_ROLE_ID";
    private static final String COLUMN_APPLY_URL = "APPLY_URL";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_JOB_ID = "JOB_ID";
    private static final String COLUMN_NPC_ID = "NPC_ID";
    private static final String COLUMN_CHECK_SCRIPT = "CHECK_SCRIPT";
    private static final String COLUMN_ENABLED = "ENABLED";

    @Override
    public List<Job> retrieveAll() {
        return Query.selectAllFrom("JOB").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getJobFromResultRow);
    }

    private Job getJobFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String chatTag = row.getString(COLUMN_CHAT_TAG);
        Argb color = row.getArgbColor(COLUMN_COLOR);
        Integer parentJobId = row.getNullableInt(COLUMN_PARENT_JOB_ID);
        Long discordRoleId = row.getNullableLong(COLUMN_DISCORD_ROLE_ID);
        String applyUrl = row.getString(COLUMN_APPLY_URL);
        List<Integer> npcIds = this.getJobsNpcIds(id);
        List<JobWork> work = this.getAllEnabledJobsWork(id);
        return new Job(id, name, identifier, description, chatTag, color, parentJobId, discordRoleId, applyUrl, npcIds, work);
    }

    private List<Integer> getJobsNpcIds(int jobId) {
        return Query.selectAllFrom("JOB_NPC").where(QueryColumn.column(COLUMN_JOB_ID, jobId)).getList(row -> row.getInt(COLUMN_NPC_ID));
    }

    private List<JobWork> getAllEnabledJobsWork(int jobId) {
        return Query.selectAllFrom("JOB_WORK").where(QueryColumn.column(COLUMN_JOB_ID, jobId), QueryColumn.column(COLUMN_ENABLED, true)).getList(this::getFromResultRow);
    }

    private JobWork getFromResultRow(ResultRow row) {
        UUID id = row.getUuid(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        String checkScript = row.getString(COLUMN_CHECK_SCRIPT);
        return new JobWork(id, name, description, checkScript);
    }
}

