/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class JobRepository
extends Repository<Job, Integer> {
    @Service
    private JobDatabase jobDatabase;

    @Override
    protected RepositoryDatasource<Job, Integer> getDatasource() {
        return this.jobDatabase;
    }

    @Override
    protected Function<Job, Object> getIndexFunction() {
        return j -> j.getIdentifier().toLowerCase();
    }

    public Optional<Job> findJobByIdentifier(String jobIdentifier) {
        return this.findByIndexKeyIfExists(jobIdentifier.toLowerCase());
    }

    public List<Job> findByNpcId(int npcId) {
        return this.findListByPredicates((T j) -> j.getNpcIds().contains(npcId));
    }

    public List<Job> findWithApplyUrl() {
        return this.findListByPredicates((T j) -> !j.getApplyUrl().isBlank());
    }
}

