/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.NotFoundException;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobInfo;
import com.equestricraft.core.job.JobMemberDto;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSession;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.job.jobrank.JobRankRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.player.job.PlayerJob;
import com.equestricraft.core.player.job.PlayerJobSession;
import java.util.Comparator;
import java.util.List;

public class JobSessionImpl
implements JobSession {
    @Service
    private JobRepository jobRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private JobRankRepository jobRankRepository;
    @Service
    private PlayerJobSession playerJobSession;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public JobRank getJobsRankForXp(int jobId, Integer xp) {
        List<JobRank> ranksForJob = this.jobRankRepository.findRanksForJob(jobId);
        return ranksForJob.stream().sorted(Comparator.comparingInt(JobRank::getXpThreshold).reversed()).filter(jobRank -> xp >= jobRank.getXpThreshold()).findFirst().orElseThrow(() -> new IllegalArgumentException("No rank found for this XP value. Either the job has no ranks or there is no default rank"));
    }

    @Override
    public Job retrieveJobByIdentifier(String jobIdentifier) {
        return this.jobRepository.findJobByIdentifier(jobIdentifier).orElseThrow(() -> new NotFoundException(String.format("Could not find job with identifier '%s'", jobIdentifier)));
    }

    @Override
    public List<JobMemberDto> retrieveJobMembers(int jobId) {
        List<CorePlayer> playersInJob = this.playerRepository.findPlayersInJob(jobId);
        return playersInJob.stream().map(player -> this.toDto(jobId, (ECPlayer)player)).toList();
    }

    private JobMemberDto toDto(int jobId, ECPlayer player) {
        boolean isManager = this.playerJobSession.isPlayerJobManager(player, jobId);
        PlayerJob playerInfo = this.playerJobSession.getPlayersJobMembership(player, jobId).orElseThrow();
        JobRank rank = this.getJobsRankForXp(jobId, playerInfo.getXp());
        return new JobMemberDto(this.playerTransformer.toSimple(player.getCorePlayer()), isManager, rank.getId(), rank.getName(), playerInfo.getFinishedInductionDate() != null);
    }

    @Override
    public JobInfo retrieveJobInfo(Job job) {
        List<JobMemberDto> members = this.retrieveJobMembers(job.getId());
        List<String> heads = members.stream().filter(JobMemberDto::manager).map(jm -> jm.player().ign()).toList();
        return new JobInfo(job.getId(), job.getIdentifier(), job.getName(), job.getDescription(), heads);
    }
}

