/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job.invoice;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.job.invoice.JobInvoice;
import com.equestricraft.core.job.invoice.JobInvoiceStatus;
import java.util.List;

public class JobInvoiceDatabase
implements RepositoryDatasource<JobInvoice, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_TITLE = "TITLE";
    private static final String COLUMN_PLAYER_FROM_ID = "PLAYER_FROM_ID";
    private static final String COLUMN_PLAYER_TO_ID = "PLAYER_TO_ID";
    private static final String COLUMN_JOB_ID = "JOB_ID";
    private static final String COLUMN_PAYMENT_VALUE = "PAYMENT_VALUE";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_STATUS = "STATUS";
    private static final String COLUMN_STATUS_CHANGE_TIME = "STATUS_CHANGE_TIME";

    @Override
    public void create(JobInvoice jobInvoice) {
        Query.insertInto("JOB_INVOICE").columns(QueryColumn.column(COLUMN_TITLE, jobInvoice.getTitle()), QueryColumn.column(COLUMN_PLAYER_FROM_ID, jobInvoice.getPlayerFromId()), QueryColumn.column(COLUMN_PLAYER_TO_ID, jobInvoice.getPlayerToId()), QueryColumn.column(COLUMN_JOB_ID, jobInvoice.getJobId()), QueryColumn.column(COLUMN_PAYMENT_VALUE, jobInvoice.getPaymentValue()), QueryColumn.column(COLUMN_DESCRIPTION, jobInvoice.getDescription()), QueryColumn.column(COLUMN_TIME_STAMP, jobInvoice.getTimeStamp()), QueryColumn.column(COLUMN_STATUS, jobInvoice.getStatus()), QueryColumn.column(COLUMN_STATUS_CHANGE_TIME, jobInvoice.getStatusChangeTime())).executeGetGeneratedKey(jobInvoice::setId);
    }

    @Override
    public List<JobInvoice> retrieveAll() {
        return Query.selectAllFrom("JOB_INVOICE").getList(this::getFromResultRow);
    }

    private JobInvoice getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String title = row.getString(COLUMN_TITLE);
        int fromPlayerId = row.getInt(COLUMN_PLAYER_FROM_ID);
        int toPlayerId = row.getInt(COLUMN_PLAYER_TO_ID);
        int jobId = row.getInt(COLUMN_JOB_ID);
        double paymentValue = row.getDouble(COLUMN_PAYMENT_VALUE);
        String description = row.getString(COLUMN_DESCRIPTION);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        JobInvoiceStatus status = row.getEnum(COLUMN_STATUS, JobInvoiceStatus.class);
        long statusChangeTime = row.getLong(COLUMN_STATUS_CHANGE_TIME);
        return new JobInvoice(id, title, fromPlayerId, toPlayerId, jobId, paymentValue, description, timeStamp, status, statusChangeTime);
    }

    @Override
    public void update(JobInvoice jobInvoice) {
        Query.update("JOB_INVOICE").set(QueryColumn.column(COLUMN_STATUS, jobInvoice.getStatus()), QueryColumn.column(COLUMN_STATUS_CHANGE_TIME, jobInvoice.getStatusChangeTime())).where(QueryColumn.column(COLUMN_ID, jobInvoice.getId())).execute();
    }
}

