/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job.invoice;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSettings;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.invoice.JobInvoice;
import com.equestricraft.core.job.invoice.JobInvoiceException;
import com.equestricraft.core.job.invoice.JobInvoiceInfo;
import com.equestricraft.core.job.invoice.JobInvoiceRepository;
import com.equestricraft.core.job.invoice.JobInvoiceSession;
import com.equestricraft.core.job.invoice.JobInvoiceStatus;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.time.Duration;
import java.util.Date;
import java.util.List;

public class JobInvoiceSessionImpl
implements JobInvoiceSession {
    @Service
    private JobInvoiceRepository jobInvoiceRepository;
    @Service
    private JobRepository jobRepository;
    @Service
    private JobTransformer jobTransformer;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public JobInvoice createInvoice(ECPlayer fromPlayer, ECPlayer toPlayer, Job job, double paymentAmount, String title, String description) {
        long now = System.currentTimeMillis();
        JobInvoice newInvoice = new JobInvoice(0, title, fromPlayer.getId(), toPlayer.getId(), job.getId(), paymentAmount, description, now, JobInvoiceStatus.NEW, now);
        return this.jobInvoiceRepository.add(newInvoice);
    }

    @Override
    public void payInvoice(int invoiceId) throws JobInvoiceException {
        JobInvoice invoice = (JobInvoice)this.jobInvoiceRepository.findByKey(invoiceId);
        if (invoice.getStatus() != JobInvoiceStatus.NEW) {
            throw new JobInvoiceException(I18n.getLabel("job.invoice.cannot-pay-invoice"));
        }
        CorePlayer playerSendingMoney = (CorePlayer)this.playerRepository.findByKey(invoice.getPlayerToId());
        CorePlayer playerReceivingMoney = (CorePlayer)this.playerRepository.findByKey(invoice.getPlayerFromId());
        double paymentDue = this.determinePaymentValue(invoice);
        try {
            playerSendingMoney.getEconomy().sendTo(playerReceivingMoney, paymentDue, I18n.getLabel("job.invoice.transaction-line", invoice.getId(), invoice.getTitle()));
            invoice.setStatus(JobInvoiceStatus.PAID);
            invoice.setStatusChangeTime(System.currentTimeMillis());
            invoice.save();
        }
        catch (EconomyException ex) {
            throw new JobInvoiceException(ex);
        }
    }

    private double determinePaymentValue(JobInvoice invoice) {
        if (this.isOverdue(invoice)) {
            return PercentageUtils.increaseByPercentage(invoice.getPaymentValue(), (double)JobSettings.getInvoiceOverdueInterestPercentage());
        }
        return invoice.getPaymentValue();
    }

    private boolean isOverdue(JobInvoice jobInvoice) {
        Duration durationSinceCreated = DateUtils.durationSince(jobInvoice.getTimeStamp());
        return durationSinceCreated.toDays() > (long)JobSettings.getInvoicePaymentDueDays().intValue();
    }

    @Override
    public void cancelInvoice(int invoiceId) throws JobInvoiceException {
        JobInvoice invoice = (JobInvoice)this.jobInvoiceRepository.findByKey(invoiceId);
        if (invoice.getStatus() != JobInvoiceStatus.NEW) {
            throw new JobInvoiceException(I18n.getLabel("job.invoice.cannot-cancel-invoice"));
        }
        invoice.setStatus(JobInvoiceStatus.CANCELLED);
        invoice.setStatusChangeTime(System.currentTimeMillis());
        invoice.save();
        CorePlayer playerTo = (CorePlayer)this.playerRepository.findByKey(invoice.getPlayerToId());
        playerTo.notify(I18n.getLabel("job.invoice.due-invoice-cancelled", invoice.getId(), invoice.getTitle()));
    }

    @Override
    public List<JobInvoiceInfo> retrievePlayersDueInvoices(ECPlayer player) {
        List<JobInvoice> invoices = this.jobInvoiceRepository.findActiveInvoicesToPlayer(player.getId());
        return this.toInfoList(invoices);
    }

    private List<JobInvoiceInfo> toInfoList(List<JobInvoice> jobInvoices) {
        return jobInvoices.stream().map(this::buildInfo).toList();
    }

    private JobInvoiceInfo buildInfo(JobInvoice jobInvoice) {
        CorePlayer fromPlayer = (CorePlayer)this.playerRepository.findByKey(jobInvoice.getPlayerFromId());
        CorePlayer toPlayer = (CorePlayer)this.playerRepository.findByKey(jobInvoice.getPlayerToId());
        Job job = (Job)this.jobRepository.findByKey(jobInvoice.getJobId());
        return new JobInvoiceInfo(jobInvoice.getId(), jobInvoice.getTitle(), this.playerTransformer.toSimple(fromPlayer), this.playerTransformer.toSimple(toPlayer), this.jobTransformer.toSimple(job), jobInvoice.getPaymentValue(), EconomyUtilities.formatCurrency(jobInvoice.getPaymentValue()), jobInvoice.getDescription(), new Date(jobInvoice.getTimeStamp()), jobInvoice.getStatus(), this.isOverdue(jobInvoice));
    }
}

