/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job.request;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.request.JobPlayersAssignedPageSession;
import com.equestricraft.core.job.request.JobRequest;
import com.equestricraft.core.job.request.JobRequestInfo;
import com.equestricraft.core.job.request.JobRequestPage;
import com.equestricraft.core.job.request.JobRequestRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.Comparator;
import java.util.List;

public class JobPlayersAssignedPageSessionImpl
extends Pagination<JobRequestInfo, JobRequestPage, Object, Object>
implements JobPlayersAssignedPageSession {
    @Service
    private JobRequestRepository jobRequestRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public JobRequestPage retrievePageOfPlayersAssignedRequests(int playerId, int pageNumber) {
        List<JobRequest> requests = this.jobRequestRepository.findIncompleteRequestsAssignedToPlayer(playerId);
        List<JobRequestInfo> items = requests.stream().map(this::buildInfo).toList();
        return (JobRequestPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private JobRequestInfo buildInfo(JobRequest jobRequest) {
        CorePlayer requester = (CorePlayer)this.playerRepository.findByKey(jobRequest.getRequesterId());
        return new JobRequestInfo(jobRequest.getId(), this.playerTransformer.toSimple(requester), jobRequest.getHorseId(), jobRequest.getDescription(), jobRequest.getCreatedTime());
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(JobRequestInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<JobRequestInfo> compare(Object sortOrderObject) {
        return (r1, r2) -> (int)(r1.createdTime() - r2.createdTime());
    }

    @Override
    protected JobRequestPage buildPage(List<JobRequestInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new JobRequestPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

