/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job.request;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.job.request.JobRequest;
import java.util.List;

public class JobRequestDatabase
implements RepositoryDatasource<JobRequest, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_JOB_ID = "JOB_ID";
    private static final String COLUMN_REQUESTER_ID = "REQUESTER_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_CREATED_TIME = "CREATED_TIME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_ASSIGNED_TO_ID = "ASSIGNED_TO_ID";
    private static final String COLUMN_COMPLETE_TIME = "COMPLETE_TIME";

    @Override
    public void create(JobRequest jobRequest) {
        Query.insertInto("JOB_REQUEST").columns(QueryColumn.column(COLUMN_JOB_ID, jobRequest.getJobId()), QueryColumn.column(COLUMN_REQUESTER_ID, jobRequest.getRequesterId()), QueryColumn.column(COLUMN_HORSE_ID, jobRequest.getHorseId()), QueryColumn.column(COLUMN_CREATED_TIME, jobRequest.getCreatedTime()), QueryColumn.column(COLUMN_DESCRIPTION, jobRequest.getDescription())).executeGetGeneratedKey(jobRequest::setId);
    }

    @Override
    public List<JobRequest> retrieveAll() {
        return Query.selectAllFrom("JOB_REQUEST").getList(this::getFromResultRow);
    }

    private JobRequest getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int jobId = row.getInt(COLUMN_JOB_ID);
        int requesterId = row.getInt(COLUMN_REQUESTER_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long createdTime = row.getLong(COLUMN_CREATED_TIME);
        String description = row.getString(COLUMN_DESCRIPTION);
        Integer assignedToId = row.getNullableInt(COLUMN_ASSIGNED_TO_ID);
        Long completeTime = row.getNullableLong(COLUMN_COMPLETE_TIME);
        return new JobRequest(id, jobId, requesterId, horseId, createdTime, description, assignedToId, completeTime);
    }

    @Override
    public void update(JobRequest jobRequest) {
        Query.update("JOB_REQUEST").set(QueryColumn.column(COLUMN_ASSIGNED_TO_ID, jobRequest.getAssignedToId()), QueryColumn.column(COLUMN_COMPLETE_TIME, jobRequest.getCompleteTime())).where(QueryColumn.column(COLUMN_ID, jobRequest.getId())).execute();
    }
}

