/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.job.request;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.request.JobRequest;
import com.equestricraft.core.job.request.JobRequestDatabase;
import java.util.List;
import java.util.function.Function;

public class JobRequestRepository
extends Repository<JobRequest, Integer> {
    @Service
    private JobRequestDatabase jobRequestDatabase;

    @Override
    protected RepositoryDatasource<JobRequest, Integer> getDatasource() {
        return this.jobRequestDatabase;
    }

    @Override
    protected Function<JobRequest, Object> getIndexFunction() {
        return JobRequest::getJobId;
    }

    public List<JobRequest> findUnassignedByJob(int jobId) {
        return this.findListByPredicates(r -> r.getJobId() == jobId, r -> r.getAssignedToId() == null);
    }

    public List<JobRequest> findIncompleteRequestsAssignedToPlayer(int playerId) {
        return this.findListByPredicates(r -> r.getAssignedToId() != null && r.getAssignedToId() == playerId, r -> r.getCompleteTime() == null);
    }
}

