/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.joinleavemessage;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.JoinLeaveMessageType;
import com.equestricraft.core.joinleavemessage.JoinLeaveMessage;
import java.util.List;

public class JoinLeaveMessageDatabase
implements RepositoryDatasource<JoinLeaveMessage, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_TEXT = "TEXT";
    private static final String COLUMN_TYPE = "TYPE";
    private static final String COLUMN_ENABLED = "ENABLED";

    @Override
    public List<JoinLeaveMessage> retrieveAll() {
        return Query.selectAllFrom("JOIN_LEAVE_MESSAGE").where(QueryColumn.column(COLUMN_ENABLED, true)).getList(this::getFromResultRow);
    }

    private JoinLeaveMessage getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String text = row.getString(COLUMN_TEXT);
        JoinLeaveMessageType type = row.getEnum(COLUMN_TYPE, JoinLeaveMessageType.class);
        return new JoinLeaveMessage(id, text, type);
    }
}

