/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.joinleavemessage;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.JoinLeaveMessageType;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.joinleavemessage.JoinLeaveMessage;
import com.equestricraft.core.joinleavemessage.JoinLeaveMessageRepository;
import com.equestricraft.core.joinleavemessage.JoinLeaveMessageSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.Optional;

public class JoinLeaveMessageSessionImpl
implements JoinLeaveMessageSession {
    @Service
    private JoinLeaveMessageRepository joinLeaveMessageRepository;

    @Override
    public Optional<String> getRandomByType(JoinLeaveMessageType type) {
        List<JoinLeaveMessage> messages = this.joinLeaveMessageRepository.findAllByType(type);
        if (messages.isEmpty()) {
            return Optional.empty();
        }
        JoinLeaveMessage message = ListUtils.getRandomItem(messages);
        return Optional.of(message.getText());
    }

    @Override
    public String translatePlaceholders(ECPlayer player, String message) {
        if (message.contains("%player_ign")) {
            message = message.replace("%player_ign", player.getIgn());
        }
        if (message.contains("%player_nickname")) {
            message = message.replace("%player_nickname", player.getDisplayName().toString());
        }
        return message;
    }
}

