/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.leaderboard;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.LeaderboardDirection;
import com.equestricraft.core.leaderboard.Leaderboard;
import java.util.List;

public class LeaderboardDatabase
implements RepositoryDatasource<Leaderboard, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_DIRECTION = "DIRECTION";
    private static final String COLUMN_SCORE_LABEL = "SCORE_LABEL";
    private static final String COLUMN_START_TIME = "START_TIME";
    private static final String COLUMN_LEADERBOARD_ID = "LEADERBOARD_ID";
    private static final String COLUMN_NPC_ID = "NPC_ID";

    @Override
    public List<Leaderboard> retrieveAll() {
        return Query.selectAllFrom("LEADERBOARD").getList(this::getLeaderboardFromResultRow);
    }

    private Leaderboard getLeaderboardFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        LeaderboardDirection direction = row.getEnum(COLUMN_DIRECTION, LeaderboardDirection.class);
        String scoreLabel = row.getString(COLUMN_SCORE_LABEL);
        Long startTime = row.getNullableLong(COLUMN_START_TIME);
        List<Integer> npcIds = this.getNpcIdsForLeaderboard(id);
        return new Leaderboard(id, name, identifier, description, direction, scoreLabel, startTime, npcIds);
    }

    private List<Integer> getNpcIdsForLeaderboard(int leaderboardId) {
        return Query.selectAllFrom("LEADERBOARD_NPC").where(QueryColumn.column(COLUMN_LEADERBOARD_ID, leaderboardId)).getList(row -> row.getInt(COLUMN_NPC_ID));
    }
}

