/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.leaderboard;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.LeaderboardDirection;
import com.equestricraft.core.leaderboard.Leaderboard;
import com.equestricraft.core.leaderboard.LeaderboardEntryInfo;
import com.equestricraft.core.leaderboard.LeaderboardPage;
import com.equestricraft.core.leaderboard.LeaderboardPageService;
import com.equestricraft.core.leaderboard.LeaderboardRepository;
import com.equestricraft.core.leaderboard.LeaderboardSession;
import java.util.Comparator;
import java.util.List;

public class LeaderboardPageServiceImpl
extends Pagination<LeaderboardEntryInfo, LeaderboardPage, Object, Object>
implements LeaderboardPageService {
    @Service
    private LeaderboardRepository leaderboardRepository;
    @Service
    private LeaderboardSession leaderboardSession;

    @Override
    public LeaderboardPage retrieveLeaderboardPage(int leaderboardId, int pageNumber) {
        Leaderboard leaderboard = (Leaderboard)this.leaderboardRepository.findByKey(leaderboardId);
        List<LeaderboardEntryInfo> entries = this.leaderboardSession.getLeaderboardEntries(leaderboard);
        return (LeaderboardPage)this.paginate(entries, pageNumber, this.determineSortDirection(leaderboard), null, null);
    }

    private SortDirection determineSortDirection(Leaderboard leaderboard) {
        return switch (leaderboard.getDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case LeaderboardDirection.ASCENDING -> SortDirection.ASCENDING;
            case LeaderboardDirection.DESCENDING -> SortDirection.DESCENDING;
        };
    }

    @Override
    protected int getMaximumPerPage() {
        return 10;
    }

    @Override
    protected boolean filter(LeaderboardEntryInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<LeaderboardEntryInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(LeaderboardEntryInfo::score);
    }

    @Override
    protected LeaderboardPage buildPage(List<LeaderboardEntryInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new LeaderboardPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

