/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.leaderboard;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.LeaderboardDirection;
import com.equestricraft.core.leaderboard.Leaderboard;
import com.equestricraft.core.leaderboard.LeaderboardEntryInfo;
import com.equestricraft.core.leaderboard.LeaderboardInfo;
import com.equestricraft.core.leaderboard.LeaderboardRepository;
import com.equestricraft.core.leaderboard.LeaderboardSession;
import com.equestricraft.core.leaderboard.LeaderboardSimpleInfo;
import com.equestricraft.core.leaderboard.entry.LeaderboardEntry;
import com.equestricraft.core.leaderboard.entry.LeaderboardEntryRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class LeaderboardSessionImpl
implements LeaderboardSession {
    @Service
    private LeaderboardRepository leaderboardRepository;
    @Service
    private LeaderboardEntryRepository leaderboardEntryRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;

    @Override
    public void addEntryToLeaderboard(ECPlayer player, Leaderboard leaderboard, double value) {
        LeaderboardEntry newEntry = new LeaderboardEntry(0, leaderboard.getId(), player.getId(), value, System.currentTimeMillis());
        this.leaderboardEntryRepository.add(newEntry);
    }

    @Override
    public Optional<Double> getPlayersLeaderboardScore(ECPlayer player, Leaderboard leaderboard) {
        Optional<LeaderboardEntry> highestEntry = this.leaderboardEntryRepository.findBestEntryForPlayer(leaderboard, player);
        return highestEntry.map(LeaderboardEntry::getValue);
    }

    @Override
    public Optional<Integer> getPlayersLeaderboardPosition(ECPlayer player, Leaderboard leaderboard) {
        List<LeaderboardEntryInfo> entries = this.getLeaderboardEntries(leaderboard);
        return entries.stream().filter(e -> e.player().id() == player.getId()).findFirst().map(LeaderboardEntryInfo::position);
    }

    @Override
    public LeaderboardInfo getLeaderboard(int leaderboardId) {
        Leaderboard leaderboard = (Leaderboard)this.leaderboardRepository.findByKey(leaderboardId);
        List<LeaderboardEntryInfo> entries = this.getLeaderboardEntries(leaderboard);
        return new LeaderboardInfo(leaderboard.getId(), leaderboard.getName(), leaderboard.getDescription(), leaderboard.getScoreLabel(), entries);
    }

    @Override
    public List<LeaderboardEntryInfo> getLeaderboardEntries(Leaderboard leaderboard) {
        Date startTime = leaderboard.getStartTime() != null ? new Date(leaderboard.getStartTime()) : null;
        return this.getLeaderboardEntries(leaderboard, startTime);
    }

    @Override
    public List<LeaderboardEntryInfo> getAllTimeEntries(int leaderboardId) {
        Leaderboard leaderboard = (Leaderboard)this.leaderboardRepository.findByKey(leaderboardId);
        return this.getLeaderboardEntries(leaderboard, null);
    }

    private List<LeaderboardEntryInfo> getLeaderboardEntries(Leaderboard leaderboard, Date since) {
        List<LeaderboardEntry> allEntries = since != null ? this.leaderboardEntryRepository.findByLeaderboardSince(leaderboard.getId(), since) : this.leaderboardEntryRepository.findByLeaderboard(leaderboard.getId());
        List<Integer> uniquePlayers = allEntries.stream().map(LeaderboardEntry::getPlayerId).distinct().toList();
        List<Object> entries = new ArrayList(uniquePlayers.size());
        for (Integer player : uniquePlayers) {
            LeaderboardEntry playersBest = allEntries.stream().filter(e -> e.getPlayerId() == player.intValue()).min(this.getSortComparator(leaderboard)).orElseThrow();
            entries.add(playersBest);
        }
        entries = entries.stream().sorted(this.getSortComparator(leaderboard)).toList();
        AtomicInteger position = new AtomicInteger(1);
        return entries.stream().map(e -> this.buildEntryInfo(position.getAndIncrement(), (LeaderboardEntry)e)).toList();
    }

    @Override
    public boolean doAnyLeaderboardsUseNpc(int npcId) {
        List<Leaderboard> leaderboards = this.leaderboardRepository.findByNpc(npcId);
        return !leaderboards.isEmpty();
    }

    @Override
    public List<LeaderboardSimpleInfo> getLeaderboardsForNpc(int npcId) {
        List<Leaderboard> leaderboards = this.leaderboardRepository.findByNpc(npcId);
        return leaderboards.stream().map(this::buildSimpleInfo).toList();
    }

    private LeaderboardSimpleInfo buildSimpleInfo(Leaderboard leaderboard) {
        return new LeaderboardSimpleInfo(leaderboard.getId(), leaderboard.getName());
    }

    private LeaderboardEntryInfo buildEntryInfo(int position, LeaderboardEntry leaderboardEntry) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(leaderboardEntry.getPlayerId());
        return new LeaderboardEntryInfo(position, this.playerTransformer.toSimple(player), leaderboardEntry.getValue(), leaderboardEntry.getTimeStamp());
    }

    private Comparator<LeaderboardEntry> getSortComparator(Leaderboard leaderboard) {
        Comparator<LeaderboardEntry> comparator = Comparator.comparingDouble(LeaderboardEntry::getValue);
        return leaderboard.getDirection() == LeaderboardDirection.ASCENDING ? comparator : comparator.reversed();
    }
}

