/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.leaderboard.entry;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.leaderboard.entry.LeaderboardEntry;
import java.util.List;

public class LeaderboardEntryDatabase
implements RepositoryDatasource<LeaderboardEntry, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_LEADERBOARD_ID = "LEADERBOARD_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_ENTRY_VALUE = "ENTRY_VALUE";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(LeaderboardEntry leaderboardEntry) {
        Query.insertInto("LEADERBOARD_ENTRY").columns(QueryColumn.column(COLUMN_LEADERBOARD_ID, leaderboardEntry.getLeaderboardId()), QueryColumn.column(COLUMN_PLAYER_ID, leaderboardEntry.getPlayerId()), QueryColumn.column(COLUMN_ENTRY_VALUE, leaderboardEntry.getValue()), QueryColumn.column(COLUMN_TIME_STAMP, leaderboardEntry.getTimeStamp())).executeGetGeneratedKey(leaderboardEntry::setId);
    }

    @Override
    public List<LeaderboardEntry> retrieveAll() {
        return Query.selectAllFrom("LEADERBOARD_ENTRY").getList(this::getFromResultRow);
    }

    private LeaderboardEntry getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int leaderboardId = row.getInt(COLUMN_LEADERBOARD_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        double entryValue = row.getDouble(COLUMN_ENTRY_VALUE);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new LeaderboardEntry(id, leaderboardId, playerId, entryValue, timeStamp);
    }
}

