/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.leaderboard.entry;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.LeaderboardDirection;
import com.equestricraft.core.leaderboard.Leaderboard;
import com.equestricraft.core.leaderboard.entry.LeaderboardEntry;
import com.equestricraft.core.leaderboard.entry.LeaderboardEntryDatabase;
import com.equestricraft.core.player.ECPlayer;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class LeaderboardEntryRepository
extends Repository<LeaderboardEntry, Integer> {
    @Service
    private LeaderboardEntryDatabase leaderboardEntryDatabase;

    @Override
    protected RepositoryDatasource<LeaderboardEntry, Integer> getDatasource() {
        return this.leaderboardEntryDatabase;
    }

    @Override
    protected Function<LeaderboardEntry, Object> getIndexFunction() {
        return LeaderboardEntry::getLeaderboardId;
    }

    public List<LeaderboardEntry> findByLeaderboard(int leaderboardId) {
        return this.findListByIndexKey(leaderboardId);
    }

    public List<LeaderboardEntry> findByLeaderboardSince(int leaderboardId, Date time) {
        long millis = time.getTime();
        RepositorySearchQuery<LeaderboardEntry> query = this.createSearchQuery();
        query.filter(e -> e.getLeaderboardId() == leaderboardId);
        query.filter(e -> e.getTimeStamp() >= millis);
        return query.many();
    }

    public Optional<LeaderboardEntry> findBestEntryForPlayer(Leaderboard leaderboard, ECPlayer player) {
        RepositorySearchQuery<LeaderboardEntry> query = this.createSearchQuery();
        query.filter(e -> e.getLeaderboardId() == leaderboard.getId());
        query.filter(e -> e.getPlayerId() == player.getId());
        query.sort(this.determineComparator(leaderboard));
        return query.single();
    }

    private Comparator<LeaderboardEntry> determineComparator(Leaderboard leaderboard) {
        Comparator comparator = (o1, o2) -> (int)(o1.getValue() - o2.getValue());
        if (leaderboard.getDirection() == LeaderboardDirection.ASCENDING) {
            return comparator;
        }
        if (leaderboard.getDirection() == LeaderboardDirection.DESCENDING) {
            return comparator.reversed();
        }
        throw new IllegalArgumentException(String.format("Illegal sort order: %s", leaderboard.getDirection().name()));
    }
}

