/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.medicine;

import com.equestricraft.api.common.APIMedicineDto;
import com.equestricraft.api.common.APIMedicinesDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.medicine.MedicineTransformer;

public class APIMedicinesDtoImpl
extends MapAdapter<String, APIMedicineDto>
implements APIMedicinesDto {
    @Service
    private static MedicineRepository medicineRepository;
    @Service
    private static MedicineTransformer medicineTransformer;

    @Override
    public APIMedicineDto get(Object key) {
        Medicine medicine = this.getFromKey(key);
        return medicineTransformer.toApiDto(medicine);
    }

    private Medicine getFromKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return medicineRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Medicine)medicineRepository.findByKey(id);
        }
        throw new IllegalArgumentException("Invalid key provided");
    }
}

