/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.medicine;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.item.AbstractItemDatabase;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineConflict;
import com.equestricraft.core.medicine.MedicineSymptom;
import java.util.List;

public class MedicineDatabase
extends AbstractItemDatabase {
    public Medicine getMedicineFromItem(ECItemDetails details) {
        return Query.selectAllFrom("MEDICINE").where(QueryColumn.column("ID", details.id())).getSingle(row -> this.getMedicineFromResultRow(row, details)).orElseThrow();
    }

    private Medicine getMedicineFromResultRow(ResultRow row, ECItemDetails details) {
        Integer categoryId = row.getNullableInt("CATEGORY_ID");
        String sideEffects = row.getString("SIDE_EFFECTS");
        String precautions = row.getString("PRECAUTIONS");
        int singleDosageSize = row.getInt("SINGLE_DOSAGE_SIZE");
        String dosageUnitName = row.getString("DOSAGE_UNIT_NAME");
        int singleDosageDurationDays = row.getInt("SINGLE_DOSAGE_DURATION_DAYS");
        double singleDosageCost = row.getDouble("SINGLE_DOSAGE_COST");
        int boosterEffectivenessThresholdPercentage = row.getInt("BOOSTER_EFFECTIVENESS_THRESHOLD_PERCENTAGE");
        int maximumEffectivenessSize = row.getInt("MAXIMUM_EFFECTIVENESS_SIZE");
        int dailyOverdoseSize = row.getInt("DAILY_OVERDOSE_SIZE");
        int dailyOverdoseSpeedPercentage = row.getInt("DAILY_OVERDOSE_SPEED_PERCENTAGE");
        int dailyOverdoseJumpPercentage = row.getInt("DAILY_OVERDOSE_JUMP_PERCENTAGE");
        int maximumOverdoseStartSize = row.getInt("MAXIMUM_OVERDOSE_START_SIZE");
        int maximumOverdoseEndSize = row.getInt("MAXIMUM_OVERDOSE_END_SIZE");
        int maximumOverdoseSpeedPercentage = row.getInt("MAXIMUM_OVERDOSE_SPEED_PERCENTAGE");
        int maximumOverdoseJumpPercentage = row.getInt("MAXIMUM_OVERDOSE_JUMP_PERCENTAGE");
        List<MedicineConflict> medicineConflicts = this.getMedicineConflictsForMedicine(details.id());
        List<ItemTag> tags = this.getTags(details);
        List<MedicineSymptom> symptoms = this.getAllMedicineSymptomsForMedicine(details.id());
        return new Medicine(details.id(), details.name(), details.identifier(), details.description(), details.modItemName(), tags, categoryId, sideEffects, precautions, singleDosageSize, dosageUnitName, singleDosageDurationDays, singleDosageCost, boosterEffectivenessThresholdPercentage, maximumEffectivenessSize, dailyOverdoseSize, dailyOverdoseSpeedPercentage, dailyOverdoseJumpPercentage, maximumOverdoseStartSize, maximumOverdoseEndSize, maximumOverdoseSpeedPercentage, maximumOverdoseJumpPercentage, medicineConflicts, symptoms);
    }

    private List<MedicineConflict> getMedicineConflictsForMedicine(int medicineId) {
        List<MedicineConflict> conflicts1 = Query.selectAllFrom("MEDICINE_CONFLICT").where(QueryColumn.column("MEDICINE_1_ID", medicineId)).getList(row -> this.getMedicineConflictFromResultRow(row, "MEDICINE_2_ID"));
        List<MedicineConflict> conflicts2 = Query.selectAllFrom("MEDICINE_CONFLICT").where(QueryColumn.column("MEDICINE_2_ID", medicineId)).getList(row -> this.getMedicineConflictFromResultRow(row, "MEDICINE_1_ID"));
        return ListUtils.concatDistinct(conflicts1, conflicts2);
    }

    private MedicineConflict getMedicineConflictFromResultRow(ResultRow row, String medicineColumn) {
        int conflictMedicineId = row.getInt(medicineColumn);
        int speedPercentage = row.getInt("SPEED_PERCENTAGE");
        int jumpPercentage = row.getInt("JUMP_PERCENTAGE");
        return new MedicineConflict(conflictMedicineId, speedPercentage, jumpPercentage);
    }

    private List<MedicineSymptom> getAllMedicineSymptomsForMedicine(int medicineId) {
        return Query.selectAllFrom("MEDICINE_SYMPTOM").where(QueryColumn.column("MEDICINE_ID", medicineId)).getList(this::getFromResultRow);
    }

    private MedicineSymptom getFromResultRow(ResultRow row) {
        int symptomId = row.getInt("SYMPTOM_ID");
        int effectsPercentage = row.getInt("EFFECTS_PERCENTAGE");
        double dosageThreshold = row.getDouble("DOSAGE_THRESHOLD");
        return new MedicineSymptom(symptomId, effectsPercentage, dosageThreshold);
    }
}

