/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.medicine;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineDatabase;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class MedicineRepository
extends Repository<Medicine, Integer> {
    @Service
    private MedicineDatabase medicineDatabase;

    public void loadItems(List<ECItem> items) {
        this.clearRepository();
        for (ECItem item : items) {
            if (!(item instanceof Medicine)) continue;
            Medicine medicine = (Medicine)item;
            this.addToCache(medicine);
        }
    }

    @Override
    protected Function<Medicine, Object> getIndexFunction() {
        return ECItem::getIdentifier;
    }

    public Optional<Medicine> findByIdentifier(String identifier) {
        return this.findByIndexKeyIfExists(identifier);
    }

    public Medicine loadMedicineFromItem(ECItemDetails details) {
        Medicine medicine = this.medicineDatabase.getMedicineFromItem(details);
        return this.addToCache(medicine);
    }

    public List<Medicine> findMedicinesByMedicineCategory(int categoryId) {
        return this.findListByPredicates((T m) -> m.getCategoryId() != null && m.getCategoryId() == categoryId);
    }
}

