/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.namegenerator;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.namegenerator.NameGeneratorName;
import com.equestricraft.core.namegenerator.NameGeneratorNameRepository;
import com.equestricraft.core.namegenerator.NameGeneratorSession;
import java.util.ArrayList;
import java.util.List;

public class NameGeneratorSessionImpl
implements NameGeneratorSession {
    @Service
    private NameGeneratorNameRepository nameGeneratorNameRepository;

    @Override
    public String getRandomName() {
        List allNames = this.nameGeneratorNameRepository.findAll();
        if (allNames.isEmpty()) {
            throw new IllegalArgumentException("Must be at least one name on the name generator list");
        }
        NameGeneratorName name = (NameGeneratorName)ListUtils.getRandomItem(allNames);
        return name.getText();
    }

    @Override
    public List<String> getAllNames() {
        List allNames = this.nameGeneratorNameRepository.findAll();
        return allNames.stream().map(NameGeneratorName::getText).toList();
    }

    @Override
    public String getRandomName(int parts) {
        List allNames = this.nameGeneratorNameRepository.findAll();
        if (allNames.size() < parts) {
            throw new IllegalArgumentException(String.format("Must be at least %s names configured on the name generator list", parts));
        }
        ArrayList<String> names = new ArrayList<String>(parts);
        while (names.size() < parts) {
            String name = ((NameGeneratorName)ListUtils.getRandomItem(allNames)).getText();
            if (names.contains(name)) continue;
            names.add(name);
        }
        return String.join((CharSequence)" ", names);
    }
}

