/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.navigator;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.navigator.NavigatorItem;
import java.util.List;
import java.util.UUID;

public class NavigatorItemDatabase
implements RepositoryDatasource<NavigatorItem, UUID> {
    @Override
    public List<NavigatorItem> retrieveAll() {
        return Query.selectAllFrom("NAVIGATOR_ITEM").where(QueryColumn.column("ENABLED", true)).getList(this::getFromResultRow);
    }

    private NavigatorItem getFromResultRow(ResultRow row) {
        UUID id = row.getUuid("ID");
        String name = row.getString("NAME");
        String description = row.getString("DESCRIPTION");
        DirectionalCoordinate coordinate = row.getDirectionalCoordinate("COORDINATE");
        return new NavigatorItem(id, name, description, coordinate);
    }
}

