/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.npc;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.common.NPCBodyType;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPCAdapter;
import com.equestricraft.core.npc.NPCFunction;
import java.util.List;
import java.util.Objects;

public class NPC
extends NPCAdapter
implements RepositoryEntity<Integer> {
    private final int id;
    private final String name;
    private final DirectionalCoordinate location;
    private final boolean hidden;
    private final NPCBodyType npcBodyType;
    private final String skinTexture;
    private final Integer characterProfileId;
    private final boolean freeze;
    private final boolean enabled;
    private final List<NPCFunction> npcFunctions;
    private final List<String> backgroundTalks;

    public NPC(int id, String name, DirectionalCoordinate location, boolean hidden, NPCBodyType npcBodyType, String skinTexture, Integer characterProfileId, boolean freeze, boolean enabled, List<NPCFunction> npcFunctions, List<String> backgroundTalks) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.hidden = hidden;
        this.npcBodyType = npcBodyType;
        this.skinTexture = skinTexture;
        this.characterProfileId = characterProfileId;
        this.freeze = freeze;
        this.enabled = enabled;
        this.npcFunctions = npcFunctions;
        this.backgroundTalks = backgroundTalks;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DirectionalCoordinate getLocation() {
        return this.location;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public NPCBodyType getNpcBodyType() {
        return this.npcBodyType;
    }

    public String getSkinTexture() {
        return this.skinTexture;
    }

    @Override
    public Integer getCharacterProfileId() {
        return this.characterProfileId;
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<NPCFunction> getNpcFunctions() {
        return this.npcFunctions;
    }

    public List<String> getBackgroundTalks() {
        return this.backgroundTalks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPC npc = (NPC)o;
        return this.id == npc.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

