/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.npc;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.NPCBodyType;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCFunction;
import java.util.List;

public class NPCDatabase
implements RepositoryDatasource<NPC, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_LOCATION = "LOCATION";
    private static final String COLUMN_HIDDEN = "HIDDEN";
    private static final String COLUMN_BODY_TYPE = "BODY_TYPE";
    private static final String COLUMN_SKIN_TEXTURE = "SKIN_TEXTURE";
    private static final String COLUMN_CHARACTER_PROFILE_ID = "CHARACTER_PROFILE_ID";
    private static final String COLUMN_FREEZE = "FREEZE";
    private static final String COLUMN_ENABLED = "ENABLED";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";
    private static final String COLUMN_NPC_FUNCTION_IDENTIFIER = "NPC_FUNCTION_IDENTIFIER";
    private static final String COLUMN_NPC_ID = "NPC_ID";
    private static final String COLUMN_MESSAGE = "MESSAGE";

    @Override
    public List<NPC> retrieveAll() {
        return Query.selectAllFrom("NPC").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private NPC getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        DirectionalCoordinate directionalCoordinate = row.getDirectionalCoordinate(COLUMN_LOCATION);
        boolean hidden = row.getBoolean(COLUMN_HIDDEN);
        NPCBodyType npcBodyType = row.getEnum(COLUMN_BODY_TYPE, NPCBodyType.class);
        String skinTexture = row.getString(COLUMN_SKIN_TEXTURE);
        Integer characterProfileId = row.getNullableInt(COLUMN_CHARACTER_PROFILE_ID);
        boolean freeze = row.getBoolean(COLUMN_FREEZE);
        boolean enabled = row.getBoolean(COLUMN_ENABLED);
        List<NPCFunction> npcFunctions = this.getNpcFunctionsForNpc(id);
        List<String> backgroundTalks = this.getBackgroundTalksForNpc(id);
        return new NPC(id, name, directionalCoordinate, hidden, npcBodyType, skinTexture, characterProfileId, freeze, enabled, npcFunctions, backgroundTalks);
    }

    private List<NPCFunction> getNpcFunctionsForNpc(int npcId) {
        return Query.selectAllFrom("NPC_FUNCTION_NPC").where(QueryColumn.column(COLUMN_NPC_ID, npcId)).getList(this::getNpcFunctionFromResultRow);
    }

    private NPCFunction getNpcFunctionFromResultRow(ResultRow row) {
        return row.getEnum(COLUMN_NPC_FUNCTION_IDENTIFIER, NPCFunction.class);
    }

    private List<String> getBackgroundTalksForNpc(int npcId) {
        return Query.selectAllFrom("NPC_BACKGROUND_TALK").where(QueryColumn.column(COLUMN_NPC_ID, npcId)).getList(s -> s.getString(COLUMN_MESSAGE));
    }
}

