/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.npc;

import com.equestricraft.base.eventbus.ECEvent;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;

public class NPCWaypointSetEvent
extends ECEvent {
    private final NPC npc;
    private final ECPlayer player;
    private final Coordinate waypoint;
    private final double speed;
    private final Runnable onReachAction;
    private final Integer minimumDistance;
    private final Runnable minimumDistanceInitialAction;
    private final Duration minimumDistanceTimeLimit;
    private final Runnable onMinimumDistanceAction;
    private final Integer maximumDistance;
    private final Runnable maximumDistanceInitialAction;
    private final Duration maximumDistanceTimeLimit;
    private final Runnable onMaximumDistanceAction;

    private NPCWaypointSetEvent(NPC npc, ECPlayer player, Coordinate waypoint, double speed, Runnable onReachAction, Integer minimumDistance, Runnable minimumDistanceInitialAction, Duration minimumDistanceTimeLimit, Runnable onMinimumDistanceAction, Integer maximumDistance, Runnable maximumDistanceInitialAction, Duration maximumDistanceTimeLimit, Runnable onMaximumDistanceAction) {
        this.npc = npc;
        this.player = player;
        this.waypoint = waypoint;
        this.speed = speed;
        this.onReachAction = onReachAction;
        this.minimumDistance = minimumDistance;
        this.minimumDistanceInitialAction = minimumDistanceInitialAction;
        this.minimumDistanceTimeLimit = minimumDistanceTimeLimit;
        this.onMinimumDistanceAction = onMinimumDistanceAction;
        this.maximumDistance = maximumDistance;
        this.maximumDistanceInitialAction = maximumDistanceInitialAction;
        this.maximumDistanceTimeLimit = maximumDistanceTimeLimit;
        this.onMaximumDistanceAction = onMaximumDistanceAction;
    }

    public NPC getNpc() {
        return this.npc;
    }

    public ECPlayer getPlayer() {
        return this.player;
    }

    public Coordinate getWaypoint() {
        return this.waypoint;
    }

    public double getSpeed() {
        return this.speed;
    }

    public Runnable getOnReachAction() {
        return this.onReachAction;
    }

    public Integer getMinimumDistance() {
        return this.minimumDistance;
    }

    public Runnable getMinimumDistanceInitialAction() {
        return this.minimumDistanceInitialAction;
    }

    public Duration getMinimumDistanceTimeLimit() {
        return this.minimumDistanceTimeLimit;
    }

    public Runnable getOnMinimumDistanceAction() {
        return this.onMinimumDistanceAction;
    }

    public Integer getMaximumDistance() {
        return this.maximumDistance;
    }

    public Runnable getMaximumDistanceInitialAction() {
        return this.maximumDistanceInitialAction;
    }

    public Duration getMaximumDistanceTimeLimit() {
        return this.maximumDistanceTimeLimit;
    }

    public Runnable getOnMaximumDistanceAction() {
        return this.onMaximumDistanceAction;
    }

    public static class Builder {
        private final NPC npc;
        private final Coordinate coordinate;
        private double speed = 1.0;
        private ECPlayer player = null;
        private Runnable onReachAction = null;
        private Integer minimumDistance = null;
        private Runnable minimumDistanceInitialAction = null;
        private Duration minimumDistanceDuration = null;
        private Runnable onMinimumDistanceAction = null;
        private Integer maximumDistance = null;
        private Runnable maximumDistanceInitialAction = null;
        private Duration maximumDistanceDuration = null;
        private Runnable onMaximumDistanceAction = null;

        private Builder(NPC npc, Coordinate coordinate) {
            this.npc = npc;
            this.coordinate = coordinate;
        }

        public Builder withSpeed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder withPlayer(ECPlayer player) {
            this.player = player;
            return this;
        }

        public Builder withOnReachAction(Runnable onReachAction) {
            this.onReachAction = onReachAction;
            return this;
        }

        public Builder withMinimumDistance(Integer distance, Runnable initialAction, Duration duration, Runnable action) {
            this.minimumDistance = distance;
            this.minimumDistanceInitialAction = initialAction;
            this.minimumDistanceDuration = duration;
            this.onMinimumDistanceAction = action;
            return this;
        }

        public Builder withMaximumDistance(Integer distance, Runnable initialAction, Duration duration, Runnable action) {
            this.maximumDistance = distance;
            this.maximumDistanceInitialAction = initialAction;
            this.maximumDistanceDuration = duration;
            this.onMaximumDistanceAction = action;
            return this;
        }

        public NPCWaypointSetEvent complete() {
            return new NPCWaypointSetEvent(this.npc, this.player, this.coordinate, this.speed, this.onReachAction, this.minimumDistance, this.minimumDistanceInitialAction, this.minimumDistanceDuration, this.onMinimumDistanceAction, this.maximumDistance, this.maximumDistanceInitialAction, this.maximumDistanceDuration, this.onMaximumDistanceAction);
        }

        public static Builder start(NPC npc, Coordinate coordinate) {
            return new Builder(npc, coordinate);
        }
    }
}

