/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.nutrient;

import com.equestricraft.common.Range;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.nutrient.NutrientConfig;
import com.equestricraft.core.nutrient.NutrientConfigAge;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;

public enum Nutrient {
    VITAMIN_A,
    VITAMIN_B1,
    VITAMIN_B2,
    VITAMIN_B3,
    VITAMIN_B5,
    VITAMIN_B6,
    VITAMIN_B7,
    VITAMIN_B9,
    VITAMIN_B12,
    VITAMIN_C,
    VITAMIN_D,
    VITAMIN_E,
    VITAMIN_K,
    PROTEIN,
    FIBER,
    MINERALS,
    CARBS,
    FLUIDS,
    FAT,
    ELECTROLYTE,
    SUGAR;

    private NutrientConfig config = null;

    public String getName() {
        return this.getConfig().getName();
    }

    public String getUnit() {
        return this.getConfig().getUnit();
    }

    public double getCaloriesPerUnit() {
        return this.getConfig().getCaloriesPerUnit();
    }

    public boolean hasCaloriesPerUnit() {
        return this.getCaloriesPerUnit() > 0.0;
    }

    public int getBurnPriority() {
        return this.getConfig().getBurnPriority();
    }

    public Range<Double> getRangeForAge(int ageMonths) {
        List<NutrientConfigAge> ageConfigs = this.getConfig().getAgeConfigs();
        if (ageConfigs.isEmpty()) {
            return Range.of(0.0, 0.0);
        }
        NutrientConfigAge lowConfig = ageConfigs.get(0);
        NutrientConfigAge highConfig = null;
        for (NutrientConfigAge ageConfig : ageConfigs) {
            if (lowConfig == null) {
                lowConfig = ageConfig;
                continue;
            }
            if (ageConfig.getAgeMonths() > ageMonths) {
                lowConfig = ageConfig;
                continue;
            }
            highConfig = ageConfig;
        }
        return Range.of(this.getValue(lowConfig, highConfig, NutrientConfigAge::getTargetMinimum, ageMonths), this.getValue(lowConfig, highConfig, NutrientConfigAge::getTargetMaximum, ageMonths));
    }

    private double getValue(NutrientConfigAge lowConfig, NutrientConfigAge highConfig, ToDoubleFunction<NutrientConfigAge> valueFunction, int ageMonths) {
        highConfig = highConfig != null ? highConfig : lowConfig;
        double lowValue = valueFunction.applyAsDouble(lowConfig);
        double highValue = valueFunction.applyAsDouble(highConfig);
        int monthsIntoCurrent = ageMonths - lowConfig.getAgeMonths();
        int endMonthsOfCurrent = highConfig.getAgeMonths() - lowConfig.getAgeMonths();
        if (endMonthsOfCurrent == 0) {
            return lowValue;
        }
        double percentage = (double)monthsIntoCurrent / (double)endMonthsOfCurrent * 100.0;
        double valueDifference = highValue - lowValue;
        double percentageToAddToLowest = PercentageUtils.of(valueDifference, percentage);
        return lowValue * percentageToAddToLowest;
    }

    public NutrientConfig getConfig() {
        return Objects.requireNonNull(this.config, "Config not set");
    }

    void setConfig(NutrientConfig config) {
        this.config = config;
    }

    public static List<Nutrient> getOrderedWithCalories() {
        return Arrays.stream(Nutrient.values()).filter(Nutrient::hasCaloriesPerUnit).sorted(Comparator.comparingInt(Nutrient::getBurnPriority)).toList();
    }
}

