/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.nutrient;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.nutrient.Nutrient;
import com.equestricraft.core.nutrient.NutrientConfigAge;
import java.util.List;
import java.util.Objects;

public class NutrientConfig
implements RepositoryEntity<String> {
    private final Nutrient identifier;
    private final String name;
    private final String unit;
    private final double caloriesPerUnit;
    private final int burnPriority;
    private final List<NutrientConfigAge> ageConfigs;

    public NutrientConfig(Nutrient identifier, String name, String unit, double caloriesPerUnit, int burnPriority, List<NutrientConfigAge> ageConfigs) {
        this.identifier = identifier;
        this.name = name;
        this.unit = unit;
        this.caloriesPerUnit = caloriesPerUnit;
        this.burnPriority = burnPriority;
        this.ageConfigs = ageConfigs;
    }

    @Override
    public String getKey() {
        return this.getIdentifier().name();
    }

    public Nutrient getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public double getCaloriesPerUnit() {
        return this.caloriesPerUnit;
    }

    public int getBurnPriority() {
        return this.burnPriority;
    }

    public List<NutrientConfigAge> getAgeConfigs() {
        return this.ageConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutrientConfig that = (NutrientConfig)o;
        return Objects.equals((Object)this.identifier, (Object)that.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier});
    }

    public String toString() {
        return this.getName();
    }
}

